/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.i18n;

import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinRequest;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public class ControlCenterI18NProvider
implements I18NProvider,
ApplicationListener<ApplicationReadyEvent> {
    static final String PREVIEW_APPLICATION_LABEL = "vaadin.com/owned-by";
    static final String PREVIEW_MARKER_LABEL = "vaadin.com/i18n.preview";
    static final String PREVIEW_LANGUAGE_LABEL = "vaadin.com/i18n.preview.language";
    static final String PREVIEW_DEFAULT_LANGUAGE_LABEL = "vaadin.com/i18n.preview.default-language";
    static final String I18N_PREVIEW_COOKIE = "i18n-preview";
    private static final Pattern INVALID_CONFIG_KEY_CHARS_PATTERN = Pattern.compile("[^-._a-zA-Z0-9]");
    private final Map<Locale, Translation> translations = new HashMap<Locale, Translation>();
    private Locale defaultLanguage;
    private final I18NProvider defaultProvider;
    private final transient KubernetesClient client;
    private transient Environment environment;

    ControlCenterI18NProvider(KubernetesClient client, I18NProvider defaultProvider) {
        this.client = client;
        this.defaultProvider = defaultProvider;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.environment = event.getApplicationContext().getEnvironment();
        this.watchConfigMaps(this.getConfigMapWatcher());
    }

    void watchConfigMaps(Watcher<ConfigMap> watcher) {
        String applicationId = this.environment.getProperty("spring.application.name");
        if (applicationId == null || applicationId.isEmpty()) {
            ControlCenterI18NProvider.getLogger().warn("No application ID set. Not watching ConfigMaps for translations.");
            return;
        }
        try {
            ControlCenterI18NProvider.getLogger().info("Watching ConfigMaps for application {}", (Object)applicationId);
            ((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.client.getNamespace())).withLabel(PREVIEW_MARKER_LABEL)).withLabel(PREVIEW_APPLICATION_LABEL, applicationId)).watch(watcher);
        }
        catch (Exception e) {
            ControlCenterI18NProvider.getLogger().error("Error watching ConfigMaps", (Throwable)e);
        }
    }

    private Watcher<ConfigMap> getConfigMapWatcher() {
        return new Watcher<ConfigMap>(){

            public void eventReceived(Watcher.Action action, ConfigMap resource) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        ControlCenterI18NProvider.this.addOrUpdateTranslation(resource);
                        break;
                    }
                    case DELETED: {
                        ControlCenterI18NProvider.this.removeTranslation(resource);
                        break;
                    }
                }
            }

            public void onClose(WatcherException cause) {
                ControlCenterI18NProvider.getLogger().error("ConfigMaps watcher closed with: {}. Retrying...", (Object)cause.getMessage(), (Object)cause);
                ControlCenterI18NProvider.this.watchConfigMaps(ControlCenterI18NProvider.this.getConfigMapWatcher());
            }
        };
    }

    void addOrUpdateTranslation(ConfigMap resource) {
        ControlCenterI18NProvider.getLogger().info("Adding or updating translation for ConfigMap {}", (Object)resource.getMetadata().getName());
        Locale locale = this.detectLocale(resource);
        if (locale == null) {
            return;
        }
        boolean isDefault = this.isDefaultLanguage(resource);
        if (isDefault) {
            this.defaultLanguage = locale;
        }
        this.translations.put(locale, new Translation(locale, new HashMap<String, String>(resource.getData())));
    }

    private void removeTranslation(ConfigMap resource) {
        Locale locale = this.detectLocale(resource);
        this.translations.remove(locale);
        if (Objects.equals(locale, this.defaultLanguage)) {
            this.defaultLanguage = null;
        }
    }

    private boolean isDefaultLanguage(ConfigMap map) {
        return String.valueOf(true).equals(map.getMetadata().getLabels().get(PREVIEW_DEFAULT_LANGUAGE_LABEL));
    }

    private Locale detectLocale(ConfigMap configMap) {
        String languageTag = (String)configMap.getMetadata().getLabels().get(PREVIEW_LANGUAGE_LABEL);
        if (languageTag == null || languageTag.isEmpty()) {
            ControlCenterI18NProvider.getLogger().warn("ConfigMap {} does not have a language tag label. Ignoring.", (Object)configMap.getMetadata().getName());
            return null;
        }
        String sanitizedLanguageTag = languageTag.replace("_", "-");
        return Locale.forLanguageTag(sanitizedLanguageTag);
    }

    private Optional<Translation> resolveLanguage(Locale locale) {
        Optional<Translation> language = Optional.ofNullable(this.translations.get(locale));
        language = language.or(() -> this.translations.keySet().stream().filter(l -> l.getLanguage().equals(locale.getLanguage())).min(Comparator.comparing(Locale::toLanguageTag)).map(this.translations::get));
        return language.or(() -> Optional.ofNullable(this.translations.get(this.defaultLanguage)));
    }

    private String generateConfigMapKey(String messageKey) {
        messageKey = INVALID_CONFIG_KEY_CHARS_PATTERN.matcher(messageKey).replaceAll("_");
        return messageKey.substring(0, Math.min(messageKey.length(), 253));
    }

    public List<Locale> getProvidedLocales() {
        HashSet<Locale> providedLocales = new HashSet<Locale>();
        if (this.isPreviewEnabled()) {
            providedLocales.addAll(this.translations.keySet());
        } else if (this.defaultProvider != null) {
            return this.defaultProvider.getProvidedLocales();
        }
        return providedLocales.stream().sorted((l1, l2) -> {
            if (l1.equals(this.defaultLanguage)) {
                return -1;
            }
            if (l2.equals(this.defaultLanguage)) {
                return 1;
            }
            return l1.toLanguageTag().compareTo(l2.toLanguageTag());
        }).toList();
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        if (this.isPreviewEnabled()) {
            Optional<Translation> maybePreviewLanguage = this.resolveLanguage(locale);
            if (maybePreviewLanguage.isEmpty()) {
                return ControlCenterI18NProvider.getTranslationNotFound(key, locale);
            }
            String configMapKey = this.generateConfigMapKey(key);
            Translation previewTranslation = maybePreviewLanguage.get();
            String translation = previewTranslation.translations().get(configMapKey);
            if (translation == null) {
                return ControlCenterI18NProvider.getTranslationNotFound(key, locale);
            }
            if (params.length > 0) {
                translation = new MessageFormat(translation, previewTranslation.locale()).format(params);
            }
            return translation;
        }
        if (this.defaultProvider == null) {
            return ControlCenterI18NProvider.getTranslationNotFound(key, locale);
        }
        return this.defaultProvider.getTranslation(key, locale, params);
    }

    private boolean isPreviewEnabled() {
        VaadinRequest request = VaadinRequest.getCurrent();
        if (request == null || request.getCookies() == null) {
            return false;
        }
        return Arrays.stream(request.getCookies()).filter(cookie -> I18N_PREVIEW_COOKIE.equals(cookie.getName())).findFirst().map(cookie -> Boolean.parseBoolean(cookie.getValue())).orElse(false);
    }

    private static String getTranslationNotFound(String key, Locale locale) {
        ControlCenterI18NProvider.getLogger().debug("Missing translation for locale {}", (Object)locale);
        return "!" + locale.toLanguageTag() + ": " + key;
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(ControlCenterI18NProvider.class);
    }

    record Translation(Locale locale, Map<String, String> translations) {
    }
}

