/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.actuate;

import com.vaadin.flow.server.Version;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.ApplicationContext;

public class VaadinInfoContributor
implements InfoContributor {
    public static final String VAADIN_KEY = "vaadin";
    public static final String FLOW_VERSION_KEY = "flowVersion";
    public static final String APPLICATION_CONTEXT_KEY = "applicationContext";
    public static final String CONTROL_CENTER_VERSION_KEY = "controlCenterVersion";
    private final ApplicationContext applicationContext;

    VaadinInfoContributor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void contribute(Info.Builder builder) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put(FLOW_VERSION_KEY, Version.getFullVersion());
        infoMap.put(APPLICATION_CONTEXT_KEY, Objects.requireNonNull(this.applicationContext.getId()));
        String controlCenterVersion = this.getImplementationVersion();
        if (controlCenterVersion != null) {
            infoMap.put(CONTROL_CENTER_VERSION_KEY, controlCenterVersion);
        }
        builder.withDetail(VAADIN_KEY, infoMap);
    }

    protected String getImplementationVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }
}

