/*
 * Copyright (C) 2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.controlcenter.starter.usage;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
class UsageConfiguration {

    @Bean
    @ConditionalOnCloudPlatform(CloudPlatform.KUBERNETES)
    UsageServiceInitListener usageServiceInitListener() {
        return new UsageServiceInitListener();
    }
}
