/*-
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.idm;

import java.io.Serializable;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Identity Management properties for the application.
 */
@ConfigurationProperties(prefix = IdentityManagementProperties.PREFIX)
public final class IdentityManagementProperties implements Serializable {

    /**
     * The prefix for the Identity Management properties.
     */
    public static final String PREFIX = "vaadin.control-center.idm";

    /**
     * The enabled property.
     */
    public static final String ENABLED = PREFIX + ".enabled";

    /**
     * The login route property.
     */
    public static final String LOGIN_ROUTE = PREFIX + ".login-route";

    /**
     * The login success route property.
     */
    public static final String LOGIN_SUCCESS_ROUTE = PREFIX
            + ".login-success-route";

    /**
     * The logout success route property.
     */
    public static final String LOGOUT_SUCCESS_ROUTE = PREFIX
            + ".logout-success-route";

    /**
     * The issuer backend URI property.
     */
    public static final String ISSUER_BACKEND_URI = PREFIX
            + ".issuer-backend-uri";
    /**
     * The issuer frontend URI property.
     */
    public static final String ISSUER_FRONTEND_URI = PREFIX
            + ".issuer-frontend-uri";
    /**
     * The client ID property.
     */
    public static final String CLIENT_ID = PREFIX + ".client-id";

    /**
     * The client secret property.
     */
    public static final String CLIENT_SECRET = PREFIX + ".client-secret";

    /**
     * The client registration ID property.
     */
    public static final String CLIENT_REGISTRATION_ID = PREFIX
            + ".client-registration-id";

    /**
     * Whether to enable Identity Management with Control Center.
     * <p>
     * Default is {@code false}.
     */
    @SuppressWarnings("java:S1845")
    private boolean enabled = false;

    /**
     * The route to the login view. This is automatically set by the
     * configuration wizard and should not be changed manually.
     */
    private String loginRoute;

    /**
     * The route to redirect to after a successful login.
     */
    private String loginSuccessRoute;

    /**
     * The route to redirect to after a successful logout.
     * <p>
     * Default is {@code "{baseUrl}"}.
     */
    private String logoutSuccessRoute = "{baseUrl}";

    /**
     * The backend URI of the issuer to use for OIDC authentication.
     */
    private String issuerBackendUri;

    /**
     * The frontend URI of the issuer to use for OIDC authentication.
     */
    private String issuerFrontendUri;

    /**
     * The client ID to use for OIDC authentication.
     */
    private String clientId;

    /**
     * The client secret to use for OIDC authentication.
     */
    private String clientSecret;

    /**
     * The client registration ID.
     */
    private String clientRegistrationId;

    /**
     * Returns whether Identity Management is enabled.
     *
     * @return {@code true} if enabled; {@code false} otherwise
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Sets whether Identity Management is enabled.
     *
     * @param enabled
     *            {@code true} if enabled; {@code false} otherwise
     */
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Returns the login route.
     *
     * @return the login route
     */
    public String getLoginRoute() {
        return loginRoute;
    }

    /**
     * Sets the login route.
     *
     * @param loginRoute
     *            the login route
     */
    public void setLoginRoute(String loginRoute) {
        this.loginRoute = loginRoute;
    }

    /**
     * Returns the login success route.
     *
     * @return the login success route
     */
    public String getLoginSuccessRoute() {
        return loginSuccessRoute;
    }

    /**
     * Sets the login success route.
     *
     * @param loginSuccessRoute
     *            the login success route
     */
    public void setLoginSuccessRoute(String loginSuccessRoute) {
        this.loginSuccessRoute = loginSuccessRoute;
    }

    /**
     * Returns the logout success route.
     *
     * @return the logout success route
     */
    public String getLogoutSuccessRoute() {
        return logoutSuccessRoute;
    }

    /**
     * Sets the logout success route.
     *
     * @param logoutSuccessRoute
     *            the logout success route
     */
    public void setLogoutSuccessRoute(String logoutSuccessRoute) {
        this.logoutSuccessRoute = logoutSuccessRoute;
    }

    /**
     * Returns the issuer backend URI.
     *
     * @return the issuer backend URI
     */
    public String getIssuerBackendUri() {
        return issuerBackendUri;
    }

    /**
     * Sets the issuer backend URI.
     *
     * @param issuerBackendUri
     *            the issuer backend URI
     */
    public void setIssuerBackendUri(String issuerBackendUri) {
        this.issuerBackendUri = issuerBackendUri;
    }

    /**
     * Returns the issuer frontend URI.
     *
     * @return the issuer frontend URI
     */
    public String getIssuerFrontendUri() {
        return issuerFrontendUri;
    }

    /**
     * Sets the issuer frontend URI.
     *
     * @param issuerFrontendUri
     *            the issuer frontend URI
     */
    public void setIssuerFrontendUri(String issuerFrontendUri) {
        this.issuerFrontendUri = issuerFrontendUri;
    }

    /**
     * Returns the client ID.
     *
     * @return the client ID
     */
    public String getClientId() {
        return clientId;
    }

    /**
     * Sets the client ID.
     *
     * @param clientId
     *            the client ID
     */
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * Returns the client secret.
     *
     * @return the client secret
     */
    public String getClientSecret() {
        return clientSecret;
    }

    /**
     * Sets the client secret.
     *
     * @param clientSecret
     *            the client secret
     */
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     * Returns the client registration ID.
     *
     * @return the client registration ID
     */
    public String getClientRegistrationId() {
        return clientRegistrationId;
    }

    /**
     * Sets the client registration ID.
     *
     * @param clientRegistrationId
     *            the client registration ID
     */
    public void setClientRegistrationId(String clientRegistrationId) {
        this.clientRegistrationId = clientRegistrationId;
    }
}
