/*-
 * Copyright (C) 2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.i18n;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;

/**
 * A filter that allows enabling and disabling the i18n preview mode by setting
 * a cookie.
 */
public class I18NPreviewFilter implements Filter {

    private static final String I18N_PREVIEW_PARAM = "i18n-preview";
    private static final String I18N_PREVIEW_COOKIE = "i18n-preview";

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest httpRequest
                && response instanceof HttpServletResponse httpResponse) {
            String previewParam = httpRequest.getParameter(I18N_PREVIEW_PARAM);
            if ("enable".equals(previewParam)) {
                Cookie cookie = new Cookie(I18N_PREVIEW_COOKIE, "true");
                cookie.setPath("/");
                cookie.setHttpOnly(true);
                cookie.setSecure(true);
                httpResponse.addCookie(cookie);
            } else if ("disable".equals(previewParam)) {
                Cookie cookie = new Cookie(I18N_PREVIEW_COOKIE, "false");
                cookie.setPath("/");
                cookie.setMaxAge(0);
                cookie.setHttpOnly(true);
                cookie.setSecure(true);
                httpResponse.addCookie(cookie);
            }
        }
        chain.doFilter(request, response);
    }
}
