/*-
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.i18n;

import java.io.Serializable;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * I18N properties for the Control Center I18N provider.
 */
@ConfigurationProperties(prefix = ControlCenterI18NProperties.PREFIX)
public final class ControlCenterI18NProperties implements Serializable {

    /**
     * The prefix for the Control Center I18N properties.
     */
    public static final String PREFIX = "vaadin.control-center.i18n";

    /**
     * The enabled property.
     */
    public static final String ENABLED = PREFIX + ".enabled";

    /**
     * The application ID property.
     */
    public static final String APPLICATION_ID = PREFIX + ".applicationId";

    /**
     * Whether to enable I18N with Control Center.
     * <p>
     * Default is {@code false}.
     */
    @SuppressWarnings("java:S1845")
    private boolean enabled = false;

    private String applicationId;

    /**
     * Returns whether Identity Management is enabled.
     *
     * @return {@code true} if enabled; {@code false} otherwise
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Sets whether Identity Management is enabled.
     *
     * @param enabled
     *            {@code true} if enabled; {@code false} otherwise
     */
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Get the name of the application for which the Control Center I18N
     * provider should preview translations.
     *
     * @return the application name
     */
    public String getApplicationId() {
        return applicationId;
    }

    /**
     * Set the name of the application for which the Control Center I18N
     * provider should preview translations.
     *
     * @param applicationId
     *            the application name
     */
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }
}
