// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.aot;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.RetryProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;

class SpringCloudKubernetesRuntimeHints implements RuntimeHintsRegistrar {

    SpringCloudKubernetesRuntimeHints() {}

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {

        hints.reflection()
                .registerTypes(
                        TypeReference.listOf(
                                KubernetesClientProperties.class,
                                ConfigMapConfigProperties.class,
                                SecretsConfigProperties.class,
                                RetryProperties.class),
                        TypeHint.builtWith(
                                MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
    }
}
