/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.aot;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class SpringCloudEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Map<String, Object> PROPERTIES = Map.of("spring.main.cloud-platform", "kubernetes", "management.endpoints.web.exposure.include", "beans,flyway,health,info,metrics,vaadin", "management.server.port", "8081");

    SpringCloudEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (Boolean.getBoolean("spring.aot.processing")) {
            environment.setActiveProfiles(new String[]{"kubernetes"});
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("enableKubernetes", PROPERTIES));
        }
    }
}

