/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.aot;

import com.vaadin.controlcenter.aot.Fabric8RuntimeHints;
import com.vaadin.controlcenter.aot.FlywayRuntimeHints;
import com.vaadin.controlcenter.aot.JosdkRuntimeHints;
import com.vaadin.controlcenter.aot.SpringCloudBeanRegistrationProcessor;
import com.vaadin.controlcenter.aot.SpringCloudKubernetesRuntimeHints;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.javaoperatorsdk.operator.processing.Controller;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigDataLocationResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;

@AutoConfiguration
public class RuntimeHintsConfiguration {
    RuntimeHintsConfiguration() {
    }

    @Bean
    @ConditionalOnClass(value={KubernetesConfigDataLocationResolver.class})
    BeanRegistrationAotProcessor springCloudBeanRegistrationProcessor() {
        return new SpringCloudBeanRegistrationProcessor();
    }

    @Configuration
    @ConditionalOnResource(resources={"db/migration"})
    @ImportRuntimeHints(value={FlywayRuntimeHints.class})
    static class FlywayRuntimeHintsConfiguration {
        FlywayRuntimeHintsConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={KubernetesClientProperties.class})
    @ImportRuntimeHints(value={SpringCloudKubernetesRuntimeHints.class})
    static class SpringCloudKubernetesRuntimeHintsConfiguration {
        SpringCloudKubernetesRuntimeHintsConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={Controller.class})
    @ImportRuntimeHints(value={JosdkRuntimeHints.class})
    static class JosdkRuntimeHintsConfiguration {
        JosdkRuntimeHintsConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={KubernetesResource.class})
    @ImportRuntimeHints(value={Fabric8RuntimeHints.class})
    static class Fabric8RuntimeHintsConfiguration {
        Fabric8RuntimeHintsConfiguration() {
        }
    }
}

