/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.aot;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.lang.Nullable;

class SpringCloudBeanRegistrationProcessor
implements BeanRegistrationExcludeFilter,
BeanRegistrationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudBeanRegistrationProcessor.class);

    SpringCloudBeanRegistrationProcessor() {
    }

    public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
        LOGGER.trace("Checking if bean is excluded from AOT processing: {}", (Object)registeredBean.getBeanName());
        return Set.of(KubernetesClient.class, KubernetesClientProperties.class).contains(registeredBean.getBeanClass());
    }

    public BeanRegistrationAotContribution processAheadOfTime(@Nullable RegisteredBean registeredBean) {
        return (generationContext, beanRegistrationCode) -> {};
    }
}

