// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.aot;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

/// Runtime hints registrar for International Components for Unicode for Java (ICU4J).
class ICU4JRuntimeHints implements RuntimeHintsRegistrar {

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.resources().registerPattern("com/ibm/icu/impl/data/icudata/**");
        hints.reflection()
                .registerType(
                        TypeReference.of("com.ibm.icu.text.NumberFormatServiceShim"),
                        builder -> builder.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS));
    }
}
