// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.aot;

import java.util.List;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

/// Runtime hints registrar for Hazelcast.
class HazelcastRuntimeHints implements RuntimeHintsRegistrar {

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        registerResourceHints(hints.resources());
        registerReflectionHints(hints.reflection());
    }

    private void registerResourceHints(ResourceHints resourceHints) {
        resourceHints.registerPattern("hazelcast.yaml");
        resourceHints.registerPattern("hazelcast-client-*.yaml");
        resourceHints.registerPattern("hazelcast-config-*.json");
        resourceHints.registerPattern("META-INF/services/*");
    }

    private void registerReflectionHints(ReflectionHints reflectionHints) {
        reflectionHints.registerTypes(
                List.of(
                        TypeReference.of("com.hazelcast.internal.cluster.Versions"),
                        TypeReference.of("com.hazelcast.instance.GeneratedBuildProperties"),
                        TypeReference.of("com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueueProducerIndexField"),
                        TypeReference.of("com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueueConsumerIndexField")),
                builder -> builder.withMembers(MemberCategory.DECLARED_FIELDS));
        reflectionHints.registerTypes(
                List.of(
                        TypeReference.of("com.hazelcast.internal.partition.impl.MigrationStats"),
                        TypeReference.of("com.hazelcast.internal.networking.nio.NioOutboundPipeline")),
                builder -> builder.withMembers(MemberCategory.INVOKE_DECLARED_METHODS));
        reflectionHints.registerTypes(
                List.of(TypeReference.of("com.hazelcast.logging.Slf4jFactory")),
                builder -> builder.withMembers(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS));
    }
}
