// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.aot;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;

/// Runtime hints registrar for Fabric8 API.
class Fabric8RuntimeHints implements RuntimeHintsRegistrar {

    private final BindingReflectionHintsRegistrar hintsRegistrar = new BindingReflectionHintsRegistrar();

    Fabric8RuntimeHints() {}

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.reflection()
                .registerTypes(
                        TypeReference.listOf(KubernetesClientImpl.class),
                        TypeHint.builtWith(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS));
        var graph = new ClassGraph().acceptPackages("io.fabric8.kubernetes.api.model");
        try (var scan = graph.scan()) {
            var types = scan.getClassesImplementing(KubernetesResource.class).stream()
                    .map(ClassInfo::loadClass)
                    .toArray(Class[]::new);
            hintsRegistrar.registerReflectionHints(hints.reflection(), types);
        }
    }
}
