/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.aot;

import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

public class HazelcastRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerResourceHints(hints.resources());
        this.registerReflectionHints(hints.reflection());
    }

    private void registerResourceHints(ResourceHints resourceHints) {
        resourceHints.registerPattern("hazelcast.yaml");
        resourceHints.registerPattern("hazelcast-client-*.yaml");
        resourceHints.registerPattern("hazelcast-config-*.json");
        resourceHints.registerPattern("META-INF/services/*");
    }

    private void registerReflectionHints(ReflectionHints reflectionHints) {
        reflectionHints.registerTypes(List.of(TypeReference.of((String)"com.hazelcast.internal.cluster.Versions"), TypeReference.of((String)"com.hazelcast.instance.GeneratedBuildProperties"), TypeReference.of((String)"com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueueProducerIndexField"), TypeReference.of((String)"com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueueConsumerIndexField")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS}));
        reflectionHints.registerTypes(List.of(TypeReference.of((String)"com.hazelcast.internal.partition.impl.MigrationStats"), TypeReference.of((String)"com.hazelcast.internal.networking.nio.NioOutboundPipeline")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS}));
        reflectionHints.registerTypes(List.of(TypeReference.of((String)"com.hazelcast.logging.Slf4jFactory")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
    }
}

