// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.aot;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.javaoperatorsdk.operator.processing.Controller;
import org.keycloak.admin.client.Keycloak;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigDataLocationResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;

/// Configuration for runtime hints.
@AutoConfiguration
public class RuntimeHintsConfiguration {

    RuntimeHintsConfiguration() {}

    @Bean
    @ConditionalOnClass(KubernetesConfigDataLocationResolver.class)
    BeanRegistrationAotProcessor springCloudBeanRegistrationProcessor() {
        return new SpringCloudBeanRegistrationProcessor();
    }

    @Configuration
    @ConditionalOnClass(KubernetesResource.class)
    @ImportRuntimeHints(Fabric8RuntimeHints.class)
    static class Fabric8RuntimeHintsConfiguration {}

    @Configuration
    @ConditionalOnClass(Controller.class)
    @ImportRuntimeHints(JosdkRuntimeHints.class)
    static class JosdkRuntimeHintsConfiguration {}

    @Configuration
    @ConditionalOnClass(Keycloak.class)
    @ImportRuntimeHints(KeycloakRuntimeHints.class)
    static class KeycloakRuntimeHintsConfiguration {}

    @Configuration
    @ConditionalOnClass(KubernetesClientProperties.class)
    @ImportRuntimeHints(SpringCloudKubernetesRuntimeHints.class)
    static class SpringCloudKubernetesRuntimeHintsConfiguration {}

    @Configuration
    @ConditionalOnResource(resources = "db/migration")
    @ImportRuntimeHints(FlywayRuntimeHints.class)
    static class FlywayRuntimeHintsConfiguration {}

    @Configuration
    @ConditionalOnResource(resources = "hazelcast.yaml")
    @ImportRuntimeHints(HazelcastRuntimeHints.class)
    static class HazelcastRuntimeHintsConfiguration {}
}
