/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.MapChange;
import java.util.EventObject;
import java.util.Objects;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;

public class MapChangeEvent
extends EventObject {
    private final String key;
    private final JsonNode oldValue;
    private final JsonNode value;

    public MapChangeEvent(CollaborationMap source, MapChange change) {
        super(source);
        Objects.requireNonNull(change, "Entry change must not be null");
        this.key = change.getKey();
        this.oldValue = change.getOldValue();
        this.value = change.getValue();
    }

    @Override
    public CollaborationMap getSource() {
        return (CollaborationMap)super.getSource();
    }

    public String getKey() {
        return this.key;
    }

    public <T> T getOldValue(Class<T> type) {
        return JsonUtil.toInstance(this.oldValue, type);
    }

    public <T> T getOldValue(TypeReference<T> typeRef) {
        return JsonUtil.toInstance(this.oldValue, typeRef);
    }

    public <T> T getValue(Class<T> type) {
        return JsonUtil.toInstance(this.value, type);
    }

    public <T> T getValue(TypeReference<T> typeRef) {
        return JsonUtil.toInstance(this.value, typeRef);
    }
}

