/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.FormManager;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.fieldhighlighter.FieldHighlighterInitializer;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

class FieldHighlighter
extends FieldHighlighterInitializer
implements Serializable {
    private final SerializableFunction<UserInfo, Integer> colorIndexProvider;

    static Registration setupForField(HasValue<?, ?> field, String propertyName, CollaborationBinder<?> binder) {
        ArrayList<Object> registrations = new ArrayList<Object>();
        if (field instanceof HasElement) {
            HasElement hasElement = (HasElement)field;
            Element element = hasElement.getElement();
            registrations.add(FieldHighlighter.init((Element)element));
            registrations.add(element.addEventListener("vaadin-highlight-show", (DomEventListener & Serializable)e -> {
                JsonNode eventData = e.getEventData();
                JsonNode eventDetail = eventData != null ? eventData.at("/event.detail") : null;
                int fieldIndex = eventDetail != null && eventDetail.has("fieldIndex") ? eventDetail.get("fieldIndex").asInt() : 0;
                binder.addEditor(propertyName, fieldIndex);
            }).addEventData("event.detail"));
            registrations.add(element.addEventListener("vaadin-highlight-hide", (DomEventListener & Serializable)e -> binder.removeEditor(propertyName)));
            registrations.add((Registration & Serializable)() -> binder.removeEditor(propertyName));
        }
        return (Registration & Serializable)() -> registrations.forEach(Registration::remove);
    }

    FieldHighlighter(SerializableFunction<UserInfo, Integer> colorIndexProvider) {
        this.colorIndexProvider = colorIndexProvider;
    }

    void setEditors(HasValue<?, ?> field, List<FormManager.FocusedEditor> editors, UserInfo localUser) {
        if (field instanceof HasElement) {
            HasElement hasElement = (HasElement)field;
            hasElement.getElement().executeJs("customElements.get('vaadin-field-highlighter').setUsers(this, $0)", new Serializable[]{this.serialize(editors.stream().filter(editor -> !editor.user.equals(localUser)))});
        }
    }

    void removeEditors(HasValue<?, ?> field) {
        this.setEditors(field, Collections.emptyList(), null);
    }

    void addEditor(HasValue<?, ?> field, UserInfo user, int fieldIndex) {
        if (field instanceof HasElement) {
            HasElement hasElement = (HasElement)field;
            hasElement.getElement().executeJs("customElements.get('vaadin-field-highlighter').addUser(this, $0)", new Serializable[]{this.serialize(user, fieldIndex)});
        }
    }

    void removeEditor(HasValue<?, ?> field, UserInfo user, int fieldIndex) {
        if (field instanceof HasElement) {
            HasElement hasElement = (HasElement)field;
            hasElement.getElement().executeJs("customElements.get('vaadin-field-highlighter').removeUser(this, $0)", new Serializable[]{this.serialize(user, fieldIndex)});
        }
    }

    private ArrayNode serialize(Stream<FormManager.FocusedEditor> editors) {
        return (ArrayNode)editors.map(this::serialize).collect(JacksonUtils.asArray());
    }

    private ObjectNode serialize(FormManager.FocusedEditor focusedEditor) {
        ObjectNode editorJson = JsonNodeFactory.instance.objectNode();
        editorJson.put("id", focusedEditor.user.getId());
        editorJson.put("name", Objects.toString(focusedEditor.user.getName(), ""));
        editorJson.put("colorIndex", (Integer)this.colorIndexProvider.apply((Object)focusedEditor.user));
        editorJson.put("fieldIndex", focusedEditor.fieldIndex);
        return editorJson;
    }

    private ObjectNode serialize(UserInfo user, int fieldIndex) {
        ObjectNode editorJson = JsonNodeFactory.instance.objectNode();
        editorJson.put("id", user.getId());
        editorJson.put("name", Objects.toString(user.getName(), ""));
        editorJson.put("colorIndex", (Integer)this.colorIndexProvider.apply((Object)user));
        editorJson.put("fieldIndex", fieldIndex);
        return editorJson;
    }
}

