/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.collaborationengine.AccessResponse;
import com.vaadin.collaborationengine.ActivationHandler;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.CollaborationEngineConfiguration;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.LocalBackend;
import com.vaadin.collaborationengine.SingleUseActivationHandler;
import com.vaadin.collaborationengine.SystemConnectionContext;
import com.vaadin.collaborationengine.Topic;
import com.vaadin.collaborationengine.TopicActivationHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.TopicConnectionRegistration;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollaborationEngine {
    static final Logger LOGGER = LoggerFactory.getLogger(CollaborationEngine.class);
    static final String COLLABORATION_ENGINE_NAME = "vaadin-collaboration-engine";
    static final String COLLABORATION_ENGINE_VERSION = "6.6";
    static final int USER_COLOR_COUNT = 7;
    private Map<String, TopicAndEventLog> topics = new ConcurrentHashMap<String, TopicAndEventLog>();
    private Map<String, Integer> userColors = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> activeTopicsCount = new ConcurrentHashMap<String, Integer>();
    private final Set<TopicConnectionRegistration> registrations = ConcurrentHashMap.newKeySet();
    private CollaborationEngineConfiguration configuration;
    private final TopicActivationHandler topicActivationHandler;
    private Clock clock = Clock.systemUTC();
    private ExecutorService executorService;
    private VaadinService vaadinService;
    private SystemConnectionContext systemContext;
    private final AtomicBoolean active = new AtomicBoolean(true);

    CollaborationEngine() {
        this((topicId, isActive) -> {});
    }

    CollaborationEngine(TopicActivationHandler topicActivationHandler) {
        this.topicActivationHandler = topicActivationHandler;
    }

    private void updateTopicActivation(String topicId, Boolean isActive) {
        if (isActive.booleanValue()) {
            this.activeTopicsCount.putIfAbsent(topicId, 0);
        }
        this.activeTopicsCount.computeIfPresent(topicId, (topic, count) -> {
            int newCount;
            int n = newCount = isActive != false ? count + 1 : count - 1;
            if (newCount <= 0) {
                this.activeTopicsCount.remove(topicId);
                this.topicActivationHandler.setActive(topicId, false);
            } else if (isActive.booleanValue() && newCount == 1) {
                this.topicActivationHandler.setActive(topicId, true);
            }
            return newCount;
        });
    }

    public static CollaborationEngine getInstance() {
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            throw new IllegalStateException("Cannot get the current CollaborationEngine instance when there is no current VaadinService instance.");
        }
        return CollaborationEngine.getInstance(service);
    }

    public static CollaborationEngine getInstance(VaadinService vaadinService) {
        Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
        return (CollaborationEngine)vaadinService.getContext().getAttribute(CollaborationEngine.class, () -> CollaborationEngine.getOrCreateConfiguration(vaadinService));
    }

    private static CollaborationEngine getOrCreateConfiguration(VaadinService vaadinService) {
        Instantiator instantiator = vaadinService.getInstantiator();
        CollaborationEngineConfiguration configuration = (CollaborationEngineConfiguration)instantiator.getOrCreate(CollaborationEngineConfiguration.class);
        return CollaborationEngine.configure(vaadinService, configuration, new CollaborationEngine(), false);
    }

    public static CollaborationEngine configure(VaadinService vaadinService, CollaborationEngineConfiguration configuration) {
        return CollaborationEngine.configure(vaadinService, configuration, new CollaborationEngine(), true);
    }

    static CollaborationEngine configure(VaadinService vaadinService, CollaborationEngineConfiguration configuration, CollaborationEngine ce, boolean storeInService) {
        Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        if (vaadinService.getContext().getAttribute(CollaborationEngine.class) != null) {
            throw new IllegalStateException("Collaboration Engine has been already configured for the provided VaadinService. The configuration can be provided only once.");
        }
        configuration.setVaadinService(vaadinService);
        ce.configuration = configuration;
        ce.vaadinService = vaadinService;
        ce.systemContext = new SystemConnectionContext((SerializableSupplier<CollaborationEngine>)(SerializableSupplier & Serializable)() -> ce);
        configuration.getBackend().setCollaborationEngine(ce);
        ExecutorService executorService = ce.configuration.getExecutorService();
        boolean useManagedExecutorService = executorService == null;
        ce.executorService = useManagedExecutorService ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()) : executorService;
        vaadinService.addServiceDestroyListener((ServiceDestroyListener & Serializable)event -> {
            ce.active.set(false);
            ce.clearConnections();
            if (useManagedExecutorService) {
                LOGGER.info("Shutting down thread pool");
                ce.executorService.shutdown();
            }
        });
        if (storeInService) {
            vaadinService.getContext().setAttribute(CollaborationEngine.class, (Object)ce);
        }
        return ce;
    }

    public TopicConnectionRegistration openTopicConnection(Component component, String topicId, UserInfo localUser, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        Objects.requireNonNull(component, "Connection context can't be null");
        ComponentConnectionContext context = new ComponentConnectionContext(component);
        return this.openTopicConnection(context, topicId, localUser, connectionActivationCallback);
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    private void clearConnections() {
        CompletableFuture future;
        LOGGER.info("Deactivating connections before shutdown");
        ArrayList futures = new ArrayList(this.registrations.size());
        LOGGER.debug("Closing {} connections", (Object)this.registrations.size());
        for (TopicConnectionRegistration registration : this.registrations) {
            registration.remove();
            registration.getPendingFuture().ifPresent(futures::add);
        }
        boolean timeoutInSeconds = true;
        Instant end = Instant.now().plus(1L, ChronoUnit.SECONDS);
        LOGGER.debug("Waiting for {} asynchronous tasks to complete", (Object)futures.size());
        Iterator iterator = futures.iterator();
        while (iterator.hasNext() && !CollaborationEngine.waitForFuture(future = (CompletableFuture)iterator.next(), end, 1L)) {
        }
        LOGGER.debug("Finished waiting for asynchronous tasks");
        this.registrations.clear();
    }

    private static boolean waitForFuture(CompletableFuture<Void> future, Instant end, long timeoutInSeconds) {
        boolean timeout = false;
        String timeoutMessage = "Timeout reached when waiting for topic connections to be closed";
        try {
            LOGGER.trace("Waiting for future to complete");
            future.get(timeoutInSeconds, TimeUnit.SECONDS);
            LOGGER.trace("Future completed successfully");
            if (Instant.now().isAfter(end)) {
                LOGGER.warn("Timeout reached when waiting for topic connections to be closed");
                timeout = true;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.info("Exception caught when closing topic connections", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout reached when waiting for topic connections to be closed", (Throwable)e);
            timeout = true;
        }
        return timeout;
    }

    private void assertConfigured() {
        if (this.configuration == null) {
            throw new IllegalStateException("Collaboration Engine is missing required configuration that should be provided by a VaadinServiceInitListener. Collaboration Engine is supported only in a Vaadin application, where VaadinService initialization is expected to happen before usage.");
        }
    }

    public TopicConnectionRegistration openTopicConnection(ConnectionContext context, String topicId, UserInfo localUser, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        Objects.requireNonNull(context, "Connection context can't be null");
        Objects.requireNonNull(topicId, "Topic id can't be null");
        Objects.requireNonNull(localUser, "User can't be null");
        Objects.requireNonNull(connectionActivationCallback, "Callback for connection activation can't be null");
        this.assertConfigured();
        if (!this.active.get()) {
            LOGGER.info("Tried to open a connection to a closed collaboration engine instance");
            return this.createFailedTopicConnectionRegistration(context);
        }
        TopicAndEventLog topicAndConnection = this.topics.computeIfAbsent(topicId, this::createTopicAndEventLog);
        BiConsumer<UUID, ObjectNode> distributor = (id, node) -> topicAndConnection.eventLog.submitEvent((UUID)id, JsonUtil.toString(node));
        TopicConnection connection = new TopicConnection((SerializableSupplier<CollaborationEngine>)(SerializableSupplier & Serializable)() -> this, context, topicAndConnection.topic, distributor, localUser, isActive -> this.updateTopicActivation(topicId, (Boolean)isActive), connectionActivationCallback);
        TopicConnectionRegistration registration = new TopicConnectionRegistration(connection, context, command -> this.getExecutorService().execute(command), (SerializableConsumer<TopicConnectionRegistration>)((SerializableConsumer & Serializable)this.registrations::remove));
        this.registrations.add(registration);
        if (!this.active.get()) {
            registration.remove();
            LOGGER.info("Tried to open a connection to a closed collaboration engine instance");
            return this.createFailedTopicConnectionRegistration(context);
        }
        return registration;
    }

    private TopicConnectionRegistration createFailedTopicConnectionRegistration(ConnectionContext context) {
        return new TopicConnectionRegistration(null, context, command -> this.getExecutorService().execute(command), (SerializableConsumer<TopicConnectionRegistration>)(SerializableConsumer & Serializable)r -> {});
    }

    private TopicAndEventLog createTopicAndEventLog(String id) {
        Backend.EventLog eventLog = this.configuration.getBackend().openEventLog(id);
        Topic topic = new Topic(id, (SerializableSupplier<CollaborationEngine>)(SerializableSupplier & Serializable)() -> this, eventLog);
        return new TopicAndEventLog(topic, eventLog);
    }

    @Deprecated(since="6.3", forRemoval=true)
    public void requestAccess(UserInfo user, Consumer<AccessResponse> requestCallback) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("You are calling the requestAccess method without a UI instance being available. You can either move the call where you are sure a UI is defined or directly provide a ConnectionContext to the method. The current UI is automatically defined when processing requests to the server. In other cases, (e.g. from background threads), the current UI is not automatically defined.");
        }
        ComponentConnectionContext context = new ComponentConnectionContext((Component)ui);
        this.requestAccess(context, user, requestCallback);
    }

    @Deprecated(since="6.3", forRemoval=true)
    public void requestAccess(ConnectionContext context, UserInfo user, Consumer<AccessResponse> requestCallback) {
        Objects.requireNonNull(context, "ConnectionContext cannot be null");
        Objects.requireNonNull(user, "UserInfo cannot be null");
        Objects.requireNonNull(requestCallback, "AccessResponse cannot be null");
        context.init(new SingleUseActivationHandler((ActivationHandler & Serializable)actionDispatcher -> {
            AccessResponse response = new AccessResponse(true);
            actionDispatcher.dispatchAction((Command & Serializable)() -> requestCallback.accept(response));
        }), command -> this.getExecutorService().execute(command));
    }

    public int getUserColorIndex(UserInfo userInfo) {
        int currentColorIndex = userInfo.getColorIndex();
        if (currentColorIndex != -1) {
            return currentColorIndex;
        }
        String userId = userInfo.getId();
        if (this.configuration.getBackend() instanceof LocalBackend) {
            return this.userColors.computeIfAbsent(userId, id -> this.userColors.size() % 7);
        }
        return Math.abs(userId.hashCode()) % 7;
    }

    CollaborationEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    Clock getClock() {
        return this.clock;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    Topic getTopic(String topicId) {
        return this.topics.get((Object)topicId).topic;
    }

    VaadinService getVaadinService() {
        return this.vaadinService;
    }

    public SystemConnectionContext getSystemContext() {
        this.assertConfigured();
        return this.systemContext;
    }

    static {
        UsageStatistics.markAsUsed((String)COLLABORATION_ENGINE_NAME, (String)COLLABORATION_ENGINE_VERSION);
    }

    private static class TopicAndEventLog {
        private final Topic topic;
        private final Backend.EventLog eventLog;

        public TopicAndEventLog(Topic topic, Backend.EventLog eventLog) {
            this.topic = topic;
            this.eventLog = eventLog;
        }
    }
}

