/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine.util;

import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.IPAddress;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.ScreenshotOnFailureRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchTestCase;
import com.vaadin.testbench.parallel.SauceLabsIntegration;
import com.vaadin.testbench.parallel.setup.SetupDriver;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class AbstractViewTest
extends TestBenchTestCase {
    private static final int SERVER_PORT = 8080;
    private final String deploymentHostname;
    private final By rootSelector;
    private static final Logger logger = Logger.getLogger(AbstractViewTest.class.getName());
    protected final boolean isSauce;
    protected final boolean isHub;
    protected final boolean isLocal;
    protected final boolean isHeadless;
    @Rule
    public ScreenshotOnFailureRule rule = new ScreenshotOnFailureRule((HasDriver)this, false);

    public AbstractViewTest() {
        this(By.tagName((String)"body"));
    }

    protected AbstractViewTest(By rootSelector) {
        boolean forceLocal = Parameters.isLocalWebDriverUsed();
        this.isHub = !forceLocal && Parameters.getHubHostname() != null;
        this.isSauce = !forceLocal && !this.isHub && SauceLabsIntegration.isConfiguredForSauceLabs();
        this.isLocal = !this.isSauce && !this.isHub;
        this.isHeadless = this.isLocal && Boolean.getBoolean("headless");
        this.deploymentHostname = this.isHub ? IPAddress.findSiteLocalAddress() : "localhost";
        this.rootSelector = rootSelector;
    }

    @Before
    public void setup() throws Exception {
        this.setDriver(this.createDriver());
        this.getDriver().get(this.getURL());
    }

    @After
    public void close() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    protected void refresh() {
        this.driver.navigate().refresh();
    }

    protected WebDriver createDriver() throws Exception {
        if (this.isSauce) {
            return this.createSauceDriver();
        }
        if (this.isHub) {
            return this.createHubDriver();
        }
        return this.createChromeDriver();
    }

    private WebDriver createChromeDriver() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--no-sandbox", "--disable-dev-shm-usage"});
        if (this.isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
        }
        logger.info("Using Local Chrome with Capabilities: " + String.valueOf(options.asMap()));
        TestBenchDriverProxy driver = TestBench.createDriver((WebDriver)new ChromeDriver(options));
        return driver;
    }

    private WebDriver createHubDriver() throws Exception {
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        desiredCapabilities.setCapability("browserName", "chrome");
        SetupDriver driverConfiguration = new SetupDriver();
        driverConfiguration.setDesiredCapabilities(desiredCapabilities);
        logger.info("Using Selenium Hub with " + String.valueOf(desiredCapabilities));
        return driverConfiguration.setupRemoteDriver("http://" + Parameters.getHubHostname() + ":4444/wd/hub");
    }

    private WebDriver createSauceDriver() throws Exception {
        SetupDriver driverConfiguration = new SetupDriver();
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        desiredCapabilities.setCapability("browserName", "chrome");
        SauceLabsIntegration.setDesiredCapabilities((DesiredCapabilities)desiredCapabilities);
        driverConfiguration.setDesiredCapabilities(desiredCapabilities);
        return driverConfiguration.setupRemoteDriver(SauceLabsIntegration.getHubUrl());
    }

    protected WebElement getRootElement() {
        return this.findElement(this.rootSelector);
    }

    protected void assertThemePresentOnElement(WebElement element, Class<? extends AbstractTheme> themeClass) {
        String themeName = themeClass.getSimpleName().toLowerCase();
        Boolean hasStyle = (Boolean)this.executeScript("var styles = Array.from(arguments[0]._template.content.querySelectorAll('style')).filter(style => style.textContent.indexOf('" + themeName + "') > -1);return styles.length > 0;", new Object[]{element});
        Assert.assertTrue((String)("Element '" + element.getTagName() + "' should have had theme '" + themeClass.getSimpleName() + "'."), (boolean)hasStyle);
    }

    protected String getURL() {
        String path = this.getRoute();
        return this.getURL(path);
    }

    protected String getURL(String path) {
        return String.format("http://%s:%d/%s", this.deploymentHostname, 8080, path);
    }

    public abstract String getRoute();
}

