/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.util.AbstractCollaborativeViewTest;
import com.vaadin.flow.component.messages.testbench.MessageElement;
import com.vaadin.flow.component.messages.testbench.MessageListElement;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SystemContextTestCommon
extends AbstractCollaborativeViewTest {
    @Override
    public String getRoute() {
        return "system";
    }

    @Test
    public void messageSubmittedToServlet_visibleInView() throws IOException {
        MessageListElement messageList = (MessageListElement)this.$(MessageListElement.class).first();
        Assert.assertEquals((String)"Sanity check", Collections.emptyList(), (Object)messageList.getMessageElements());
        this.submitToServlet("Hello world");
        this.waitUntil(driver -> !messageList.getMessageElements().isEmpty(), 3L);
        List messages = messageList.getMessageElements();
        Assert.assertEquals((long)1L, (long)messages.size());
        MessageElement messageElement = (MessageElement)messages.get(0);
        Assert.assertEquals((Object)"Hello world", (Object)messageElement.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitToServlet(String message) throws IOException {
        URL url = new URL(this.getURL("submit"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                os.write(message.getBytes(StandardCharsets.UTF_8));
            }
            if (connection.getResponseCode() != 200) {
                throw new IOException(connection.getResponseMessage());
            }
        }
        finally {
            connection.disconnect();
        }
    }
}

