/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.collaborationengine;

import java.util.UUID;

import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;

@Route("system")
public class SystemContextViewCommon extends VerticalLayout {
    public SystemContextViewCommon() {
        UserInfo localUser = new UserInfo(UUID.randomUUID().toString());
        add(new Span(
                "If this looks empty, it's because no messages have been submitted. "
                        + "To add a message, send a POST request to /submit with the message text as the POST body."),
                new CollaborationMessageList(localUser,
                        SystemContextViewCommon.class.getName()));
    }
}
