/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationMessageInput;
import com.vaadin.collaborationengine.CollaborationMessageList;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

@Route(value="chat")
public class CollaborativeChatViewCommon
extends VerticalLayout {
    CollaborationMessageList list;
    CollaborationMessageInput input;
    static AtomicInteger userCounter = new AtomicInteger(0);
    static AtomicInteger topicCounter = new AtomicInteger(0);
    NativeButton resetUserCounter = new NativeButton("Reset user counter", (ComponentEventListener & Serializable)e -> userCounter.set(0));
    NativeButton nextTopic = new NativeButton("Next topic", (ComponentEventListener & Serializable)e -> this.nextTopic());
    String currentTopic;
    Paragraph topicIndicator = new Paragraph("Current topic: ");

    public CollaborativeChatViewCommon() {
        this.addAttachListener((ComponentEventListener & Serializable)event -> event.getUI().getPushConfiguration().setPushMode(PushMode.AUTOMATIC));
        int userIndex = userCounter.incrementAndGet();
        UserInfo localUser = new UserInfo("userId-" + userIndex);
        localUser.setName("User " + userIndex);
        this.list = new CollaborationMessageList(localUser, null);
        this.input = new CollaborationMessageInput(this.list);
        this.currentTopic = "topic" + topicCounter.get();
        this.setTopic(this.currentTopic);
        VerticalLayout chat = new VerticalLayout(new Component[]{this.list, this.input});
        chat.setHeight("400px");
        chat.expand(new Component[]{this.list});
        this.resetUserCounter.setId("reset-user-counter");
        this.nextTopic.setId("next-topic");
        this.add(new Component[]{chat, this.topicIndicator, this.resetUserCounter, this.nextTopic});
        NativeButton setTopicNull = new NativeButton("Set chat topic to null", (ComponentEventListener & Serializable)e -> this.setTopic(null));
        setTopicNull.setId("set-topic-null");
        NativeButton setTopic = new NativeButton("Set old topic again", (ComponentEventListener & Serializable)e -> this.setTopic(this.currentTopic));
        setTopic.setId("set-topic");
        this.add(new Component[]{setTopicNull, setTopic});
    }

    private void nextTopic() {
        this.currentTopic = "topic" + topicCounter.incrementAndGet();
        this.setTopic(this.currentTopic);
    }

    private void setTopic(String topic) {
        this.topicIndicator.setText("Current topic: " + topic);
        this.list.setTopic(topic);
    }
}

