/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine.util;

import com.vaadin.collaborationengine.util.AbstractCollaborativeViewTest;
import com.vaadin.collaborationengine.util.UserTagElement;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openqa.selenium.TimeoutException;

public abstract class FieldHighlightUtil
extends AbstractCollaborativeViewTest {
    public void assertNoUserTags(TestBenchElement ... fields) {
        for (TestBenchElement field : fields) {
            this.assertUserTags(field, new String[0]);
        }
    }

    public void assertUserTags(TestBenchElement field, String ... expectedUsers) {
        this.assertUserTags("Unexpected user tags on field " + field, field, expectedUsers);
    }

    public void assertUserTags(String message, TestBenchElement field, String ... expectedUsers) {
        try {
            this.waitUntil(d -> Arrays.equals(this.getUserTagNames(field), expectedUsers), 3L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertArrayEquals((String)message, (Object[])expectedUsers, (Object[])this.getUserTagNames(field));
        this.validateColorIndices(this.getUserTags(field));
    }

    public String[] getUserTagNames(TestBenchElement field) {
        return (String[])this.getUserTags(field).stream().map(UserTagElement::getName).toArray(String[]::new);
    }

    private void validateColorIndices(List<UserTagElement> userTags) {
        userTags.stream().map(UserTagElement::getColorIndex).forEach(colorIndex -> Assert.assertTrue((String)("Invalid color index on a user tag. Expected integer in range 0-9, but was " + colorIndex), (colorIndex != null && colorIndex >= 0 && colorIndex < 10 ? 1 : 0) != 0));
    }

    public List<UserTagElement> getUserTags(TestBenchElement field) {
        if (!field.$("vaadin-user-tags").exists()) {
            return Collections.emptyList();
        }
        TestBenchElement tagsElement = field.$("vaadin-user-tags").first();
        List tagElements = (List)tagsElement.getCommandExecutor().executeScript("arguments[0].requestContentUpdate(); return arguments[0].wrapper.querySelectorAll('vaadin-user-tag')", new Object[]{tagsElement});
        return tagElements.stream().map(tag -> (UserTagElement)TestBench.wrap((TestBenchElement)tag, UserTagElement.class)).collect(Collectors.toList());
    }
}

