/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.util.AbstractCollaborativeFormTestCommon;
import com.vaadin.testbench.TestBenchElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AvatarGroupTestCommon
extends AbstractCollaborativeFormTestCommon {
    @Test
    public void openAndCloseClients_avatarsUpdated() throws Exception {
        Assert.assertEquals((String)"Expected only own avatar when only one client connected", this.newHashSet("User 1"), this.client1.getAvatarNames());
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        String message = "When another client has joined, expected both to have two avatars";
        Set<String> expected = this.newHashSet("User 1", "User 2");
        Assert.assertEquals((String)message, expected, this.client1.getAvatarNames());
        Assert.assertEquals((String)message, expected, client2.getAvatarNames());
        AbstractCollaborativeFormTestCommon.ClientState client3 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        message = "When three clients joined, expected to see the avatars of the other two";
        expected = this.newHashSet("User 1", "User 2", "User 3");
        Assert.assertEquals((String)message, expected, this.client1.getAvatarNames());
        Assert.assertEquals((String)message, expected, client2.getAvatarNames());
        Assert.assertEquals((String)message, expected, client3.getAvatarNames());
        this.close(client2.client);
        message = "When one of the three clients closed the window, expected one avatar to remain visible for the other two";
        expected = this.newHashSet("User 1", "User 3");
        Assert.assertEquals((String)message, expected, this.client1.getAvatarNames());
        Assert.assertEquals((String)message, expected, client3.getAvatarNames());
    }

    @Test
    public void avatarAndFieldHighlightHaveSameColorIndex() throws Exception {
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        this.client1.focusTextField();
        this.waitUntil(d -> this.getUserTags((TestBenchElement)client2.textField).size() > 0, 3L);
        Integer fieldColorIndex = this.getUserTags((TestBenchElement)client2.textField).get(0).getColorIndex();
        Integer avatarColorIndex = client2.avatars.getAvatarElement(1).getPropertyInteger(new String[]{"colorIndex"});
        Assert.assertNotNull((Object)fieldColorIndex);
        Assert.assertEquals((Object)fieldColorIndex, (Object)avatarColorIndex);
    }

    private <E> Set<E> newHashSet(E ... items) {
        return new HashSet<E>(Arrays.asList(items));
    }
}

