/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.util.AbstractCollaborativeViewTest;
import com.vaadin.flow.component.messages.testbench.MessageElement;
import com.vaadin.flow.component.messages.testbench.MessageInputElement;
import com.vaadin.flow.component.messages.testbench.MessageListElement;
import com.vaadin.testbench.TestBenchTestCase;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageListTestCommon
extends AbstractCollaborativeViewTest {
    private static final String HELLO_USERS = "hello users";
    protected ClientState client1;

    @Override
    public String getRoute() {
        return "chat";
    }

    @Before
    public void init() {
        this.client1 = new ClientState(this);
        this.clickButton("next-topic");
    }

    @After
    public void reset() {
        this.clickButton("reset-user-counter");
    }

    @Test
    public void submitMessages_messageListUpdated() throws Exception {
        Assert.assertEquals((String)"Expected the message list to be empty", (long)0L, (long)this.client1.getMessages().size());
        this.client1.submitMessage(HELLO_USERS);
        this.waitUntil(driver -> this.client1.getMessages().size() == 1);
        this.assertMessage(HELLO_USERS, this.client1.getMessages().get(0));
        ClientState client2 = new ClientState(this.addClient());
        this.waitUntil(driver -> client2.getMessages().size() == 1);
        this.assertMessage(HELLO_USERS, client2.getMessages().get(0));
        String hi = "hi";
        client2.submitMessage("hi");
        this.waitUntil(driver -> client2.getMessages().size() == 2);
        this.assertMessage("hi", client2.getMessages().get(1));
        this.waitUntil(driver -> this.client1.getMessages().size() == 2);
        this.assertMessage("hi", this.client1.getMessages().get(1));
    }

    @Test
    public void disconnectAndConnectToTopic_messageListUpdated() {
        this.client1.submitMessage(HELLO_USERS);
        this.waitUntil(webDriver -> !this.client1.getMessages().isEmpty(), 5L);
        Assert.assertEquals((String)"Expected message list to contain one message", (long)1L, (long)this.client1.getMessages().size());
        this.assertMessage(HELLO_USERS, this.client1.getMessages().get(0));
        this.clickButton("set-topic-null");
        this.waitUntil(webDriver -> this.client1.getMessages().isEmpty(), 5L);
        Assert.assertEquals((String)"Expected message list to be empty", (long)0L, (long)this.client1.getMessages().size());
        this.clickButton("set-topic");
        this.waitUntil(webDriver -> !this.client1.getMessages().isEmpty(), 5L);
        Assert.assertEquals((String)"Expected message list to contain message after connecting to topic again", (long)1L, (long)this.client1.getMessages().size());
        this.assertMessage(HELLO_USERS, this.client1.getMessages().get(0));
    }

    private void clickButton(String id) {
        this.$("button").id(id).click();
    }

    private void assertMessage(String expected, MessageElement actual) {
        Assert.assertEquals((String)String.format("Expected a message with the text '%s'", expected), (Object)expected, (Object)actual.getText());
    }

    public static class ClientState {
        public MessageListElement messageList;
        public MessageInputElement messageInput;

        public ClientState(TestBenchTestCase client) {
            this.messageList = (MessageListElement)client.$(MessageListElement.class).first();
            this.messageInput = (MessageInputElement)client.$(MessageInputElement.class).first();
        }

        public List<MessageElement> getMessages() {
            return this.messageList.getMessageElements();
        }

        public void submitMessage(String text) {
            this.messageInput.submit(text);
        }
    }
}

