/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationAvatarGroup;
import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.collaborationengine.util.Person;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

@Route(value="form")
@PreserveOnRefresh
public class CollaborativeFormViewCommon
extends VerticalLayout {
    public static final String TOPIC_ID = "topic";
    CollaborationAvatarGroup avatars;
    TextField textField = new TextField("Name");
    Checkbox checkbox = new Checkbox("Married");
    TextField email = new TextField("Email (not collaborative)");
    RadioButtonGroup<Person.Diet> radioButtonGroup = new RadioButtonGroup();
    CollaborationBinder<Person> binder;
    static AtomicInteger userCounter = new AtomicInteger(0);
    NativeButton resetUserCounter = new NativeButton("Reset user counter", (ComponentEventListener & Serializable)e -> userCounter.set(0));

    public CollaborativeFormViewCommon() {
        this.addAttachListener((ComponentEventListener & Serializable)event -> event.getUI().getPushConfiguration().setPushMode(PushMode.AUTOMATIC));
        int userIndex = userCounter.incrementAndGet();
        UserInfo localUser = new UserInfo("userId-" + userIndex);
        localUser.setName("User " + userIndex);
        localUser.setColorIndex(userIndex);
        this.avatars = new CollaborationAvatarGroup(localUser, TOPIC_ID);
        this.radioButtonGroup.setItems((Object[])Person.Diet.values());
        this.radioButtonGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        this.radioButtonGroup.setLabel("Diet");
        this.resetUserCounter.setId("reset-user-counter");
        this.email.setId("emailField");
        this.add(new Component[]{this.avatars, this.textField, this.checkbox, this.radioButtonGroup, this.resetUserCounter, this.email});
        this.binder = new CollaborationBinder(Person.class, localUser);
        this.binder.setTopic(TOPIC_ID, (SerializableSupplier & Serializable)() -> null);
        this.binder.bind((HasValue)this.textField, "name");
        this.binder.bind((HasValue)this.checkbox, "married");
        this.binder.bind(this.radioButtonGroup, "diet");
        NativeButton detachTextField = new NativeButton("Detach text field", (ComponentEventListener & Serializable)e -> this.remove(new Component[]{this.textField}));
        detachTextField.setId("detach-text-field");
        NativeButton attachTextField = new NativeButton("Attach text field", (ComponentEventListener & Serializable)e -> this.addComponentAtIndex(1, (Component)this.textField));
        attachTextField.setId("attach-text-field");
        NativeButton setBinderNull = new NativeButton("Set binder topic to null", (ComponentEventListener & Serializable)e -> this.binder.setTopic(null, Person::new));
        setBinderNull.setId("set-binder-null");
        NativeButton setBinder = new NativeButton("Bind again", (ComponentEventListener & Serializable)e -> this.binder.setTopic(TOPIC_ID, Person::new));
        setBinder.setId("set-binder");
        this.add(new Component[]{detachTextField, attachTextField, setBinderNull, setBinder});
    }
}

