/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.util.AbstractCollaborativeFormTestCommon;
import com.vaadin.collaborationengine.util.FieldOutlineElement;
import com.vaadin.flow.component.radiobutton.testbench.RadioButtonElement;
import com.vaadin.testbench.TestBenchElement;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FieldHighlightTestCommon
extends AbstractCollaborativeFormTestCommon {
    @Test
    public void noInitialUserTags() throws Exception {
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, this.client1.checkbox});
    }

    @Test
    public void focusFields_userTagsForLocalUserNotDisplayed() throws Exception {
        this.client1.focusTextField();
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, this.client1.checkbox});
        this.client1.focusCheckbox();
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, this.client1.checkbox});
    }

    @Test
    public void focusField_addClient_newClientHasUserTag() throws Exception {
        this.client1.focusTextField();
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        this.assertUserTags((TestBenchElement)client2.textField, "User 1");
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, this.client1.checkbox, client2.checkbox});
    }

    @Test
    public void addClient_focusAndBlurFields_userTagsUpdated() throws Exception {
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        this.client1.focusTextField();
        client2.focusCheckbox();
        this.assertUserTags((TestBenchElement)client2.textField, "User 1");
        this.assertUserTags((TestBenchElement)this.client1.checkbox, "User 2");
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, client2.checkbox});
        this.client1.focusCheckbox();
        this.assertUserTags((TestBenchElement)client2.checkbox, "User 1");
        this.assertUserTags((TestBenchElement)this.client1.checkbox, "User 2");
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, client2.textField});
        client2.blur();
        this.assertUserTags((TestBenchElement)client2.checkbox, "User 1");
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField, this.client1.checkbox, client2.textField});
    }

    @Test
    public void threeClients_focusSameField_twoUserTags() throws Exception {
        Assume.assumeFalse((String)"Fails in Selenium Hub", (boolean)this.isHub);
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        AbstractCollaborativeFormTestCommon.ClientState client3 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        this.client1.focusTextField();
        client2.focusTextField();
        client3.focusTextField();
        this.assertUserTags((TestBenchElement)this.client1.textField, "User 3", "User 2");
        this.assertUserTags((TestBenchElement)client2.textField, "User 3", "User 1");
        this.assertUserTags((TestBenchElement)client3.textField, "User 2", "User 1");
        client3.blur();
        this.assertUserTags((TestBenchElement)this.client1.textField, "User 2");
        this.assertUserTags((TestBenchElement)client2.textField, "User 1");
        this.assertUserTags((TestBenchElement)client3.textField, "User 2", "User 1");
    }

    @Test
    public void closeBrowser_tagRemoved() throws Exception {
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        client2.focusTextField();
        this.close(client2.client);
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField});
    }

    @Test
    public void focusRadioButtonsInsideGroup_individualButtonsHighlighted() throws Exception {
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        this.assertNoUserTags(new TestBenchElement[]{this.client1.radioButtonGroup, client2.radioButtonGroup});
        this.assertRadioButtonHighlight(this.client1, null, null, null);
        this.assertRadioButtonHighlight(client2, null, null, null);
        client2.focusRadioButton(1);
        this.assertUserTags((TestBenchElement)this.client1.radioButtonGroup, "User 2");
        this.assertNoUserTags(new TestBenchElement[]{client2.radioButtonGroup});
        this.assertRadioButtonHighlight(this.client1, null, 2, null);
        this.assertRadioButtonHighlight(client2, null, null, null);
        AbstractCollaborativeFormTestCommon.ClientState client3 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        client3.focusRadioButton(2);
        this.assertUserTags((TestBenchElement)this.client1.radioButtonGroup, "User 3", "User 2");
        this.assertUserTags((TestBenchElement)client2.radioButtonGroup, "User 3");
        this.assertUserTags((TestBenchElement)client3.radioButtonGroup, "User 2");
        this.assertRadioButtonHighlight(this.client1, null, 2, 3);
        this.assertRadioButtonHighlight(client2, null, null, 3);
        this.assertRadioButtonHighlight(client3, null, 2, null);
        client3.blur();
        this.assertUserTags((TestBenchElement)this.client1.radioButtonGroup, "User 2");
        this.assertNoUserTags(new TestBenchElement[]{client2.radioButtonGroup});
        this.assertUserTags((TestBenchElement)client3.radioButtonGroup, "User 2");
        this.assertRadioButtonHighlight(this.client1, null, 2, null);
        this.assertRadioButtonHighlight(client2, null, null, null);
        this.assertRadioButtonHighlight(client3, null, 2, null);
        client3.focusRadioButton(1);
        this.assertUserTags((TestBenchElement)this.client1.radioButtonGroup, "User 3", "User 2");
        this.assertUserTags((TestBenchElement)client2.radioButtonGroup, "User 3");
        this.assertUserTags((TestBenchElement)client3.radioButtonGroup, "User 2");
        this.assertRadioButtonHighlight(this.client1, null, 3, null);
        this.assertRadioButtonHighlight(client2, null, 3, null);
        this.assertRadioButtonHighlight(client3, null, 2, null);
    }

    @Test
    public void clientClearItsBinder_itsFieldsHaveNoHighlighters() throws Exception {
        AbstractCollaborativeFormTestCommon.ClientState client2 = new AbstractCollaborativeFormTestCommon.ClientState(this.addClient());
        client2.focusTextField();
        this.assertUserTags((TestBenchElement)this.client1.textField, "User 2");
        this.client1.clearBinder();
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField});
        this.client1.rebind();
        this.assertUserTags((TestBenchElement)this.client1.textField, "User 2");
        client2.focusCheckbox();
        this.assertNoUserTags(new TestBenchElement[]{this.client1.textField});
        this.assertUserTags((TestBenchElement)this.client1.checkbox, "User 2");
    }

    private void assertRadioButtonHighlight(AbstractCollaborativeFormTestCommon.ClientState client, Integer ... expectedColorIndices) {
        int index = 0;
        for (RadioButtonElement radioButton : client.radioButtons) {
            FieldOutlineElement outline = (FieldOutlineElement)radioButton.$(FieldOutlineElement.class).first();
            Integer colorIndex = outline.getColorIndex();
            Assert.assertEquals((String)"Radio button had unexpected color index", (Object)expectedColorIndices[index++], (Object)colorIndex);
        }
    }
}

