/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine.util;

import com.vaadin.collaborationengine.util.FieldHighlightUtil;
import com.vaadin.flow.component.avatar.testbench.AvatarElement;
import com.vaadin.flow.component.avatar.testbench.AvatarGroupElement;
import com.vaadin.flow.component.checkbox.testbench.CheckboxElement;
import com.vaadin.flow.component.radiobutton.testbench.RadioButtonElement;
import com.vaadin.flow.component.radiobutton.testbench.RadioButtonGroupElement;
import com.vaadin.flow.component.textfield.testbench.TextFieldElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.TestBenchTestCase;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractCollaborativeFormTestCommon
extends FieldHighlightUtil {
    protected ClientState client1;

    @Override
    public String getRoute() {
        return "form";
    }

    @Before
    public void init() {
        this.client1 = new ClientState(this);
    }

    @After
    public void reset() {
        this.$("button").id("reset-user-counter").click();
    }

    public static class ClientState {
        public TestBenchTestCase client;
        public AvatarGroupElement avatars;
        public TextFieldElement textField;
        public TextFieldElement emailField;
        public CheckboxElement checkbox;
        public RadioButtonGroupElement radioButtonGroup;
        public List<RadioButtonElement> radioButtons;
        TestBenchElement focusedElement;

        public ClientState(TestBenchTestCase client) {
            this.client = client;
            this.avatars = (AvatarGroupElement)client.$(AvatarGroupElement.class).first();
            this.textField = (TextFieldElement)client.$(TextFieldElement.class).first();
            this.emailField = (TextFieldElement)client.$(TextFieldElement.class).id("emailField");
            this.checkbox = (CheckboxElement)client.$(CheckboxElement.class).first();
            this.radioButtonGroup = (RadioButtonGroupElement)client.$(RadioButtonGroupElement.class).first();
            this.radioButtons = this.radioButtonGroup.$(RadioButtonElement.class).all();
        }

        public void focusTextField() {
            this.focus((TestBenchElement)this.textField);
        }

        public void focusCheckbox() {
            this.focus((TestBenchElement)this.checkbox);
        }

        public void focusRadioButton(int index) {
            this.focus((TestBenchElement)this.radioButtons.get(index));
        }

        public void focus(TestBenchElement element) {
            this.blur();
            element.dispatchEvent("focusin", Collections.singletonMap("bubbles", true));
            this.focusedElement = element;
        }

        public void blur() {
            if (this.focusedElement != null) {
                this.focusedElement.dispatchEvent("focusout", Collections.singletonMap("bubbles", true));
                this.focusedElement = null;
            }
        }

        public Set<String> getAvatarNames() {
            return this.avatars.$(AvatarElement.class).all().stream().filter(avatar -> !avatar.hasAttribute("hidden")).map(avatar -> avatar.getPropertyString(new String[]{"name"})).collect(Collectors.toSet());
        }

        public void detachTextField() {
            this.click("detach-text-field");
        }

        public void attachTextField() {
            this.click("attach-text-field");
            this.textField = (TextFieldElement)this.client.$(TextFieldElement.class).first();
        }

        public void clearBinder() {
            this.click("set-binder-null");
        }

        public void rebind() {
            this.click("set-binder");
        }

        public void click(String id) {
            this.client.$(TestBenchElement.class).id(id).click();
        }
    }
}

