/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.MessageManager;
import com.vaadin.collaborationengine.SystemContextViewCommon;
import com.vaadin.collaborationengine.SystemUserInfo;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.function.SerializableSupplier;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@WebServlet(value={"/submit"})
public class SystemContextServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CollaborationEngine ce = (CollaborationEngine)this.getServletContext().getAttribute(CollaborationEngine.class.getName());
        if (ce == null) {
            resp.sendError(500, "Collaboration Engine has not yet been initialized");
            return;
        }
        try (BufferedReader reader = req.getReader();){
            String message = reader.lines().collect(Collectors.joining("\n")).trim();
            if (message.isEmpty()) {
                resp.sendError(500, "Request must have a body");
                return;
            }
            MessageManager messageManager = new MessageManager((ConnectionContext)ce.getSystemContext(), (UserInfo)SystemUserInfo.getInstance(), SystemContextViewCommon.class.getName(), (SerializableSupplier & Serializable)() -> ce);
            messageManager.submit(message).get();
            messageManager.close();
            resp.setStatus(200);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            resp.sendError(500, e.getMessage());
        }
    }
}

