/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.vaadin.HazelcastBackend;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationEngineConfiguration;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendConfigurer
implements VaadinServiceInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackendConfigurer.class);

    public void serviceInit(ServiceInitEvent serviceEvent) {
        VaadinService service = serviceEvent.getSource();
        CollaborationEngineConfiguration configuration = new CollaborationEngineConfiguration();
        if ("hazelcast".equals(System.getProperty("ce.clustering"))) {
            HazelcastInstance hz = Hazelcast.newHazelcastInstance();
            service.addServiceDestroyListener((ServiceDestroyListener & Serializable)event -> hz.shutdown());
            configuration.setBackend((Backend)new HazelcastBackend(hz));
        }
        CollaborationEngine.configure((VaadinService)service, (CollaborationEngineConfiguration)configuration);
    }
}

