/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin;

import com.vaadin.DemoView;
import com.vaadin.collaborationengine.CollaborationAvatarGroup;
import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="")
@CssImport(value="./styles/shared-styles.css")
public class DemoView
extends VerticalLayout {
    private static final String TOPIC_ID = "form";
    private static final String ACTIVITY_LOG_MAP_NAME = "activityLog";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private Registration closeConnection;
    private CollaborationBinder<Person> binder;
    private final Div log = new Div();

    public DemoView() {
        this.addAttachListener((ComponentEventListener & Serializable)event -> event.getUI().getPushConfiguration().setPushMode(PushMode.AUTOMATIC));
        this.addClassName("centered-content");
        this.log.setClassName("log");
        this.showLogin();
    }

    private void showLogin() {
        TextField usernameField = new TextField("Username");
        Button startButton = new Button("Start editing", (ComponentEventListener & Serializable)event -> {
            String value = usernameField.getValue();
            if (!value.isEmpty()) {
                this.showPersonEditor(value);
            } else {
                Notification.show((String)"Must enter a username to collaborate");
                usernameField.focus();
            }
        });
        startButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        this.removeAll();
        this.add(new Component[]{usernameField, startButton});
    }

    private void showPersonEditor(String username) {
        TextField firstName = new TextField("First name");
        TextField lastName = new TextField("Last name");
        this.removeAll();
        Button submitButton = new Button("Submit", (ComponentEventListener & Serializable)event -> {
            Person person = new Person();
            if (this.binder.writeBeanIfValid((Object)person)) {
                this.closeConnection.remove();
                Notification.show((String)("Submit: " + person));
                this.showLogin();
            }
        });
        UserInfo user = new UserInfo(UUID.randomUUID().toString(), username);
        CollaborationAvatarGroup collaboratorsAvatars = new CollaborationAvatarGroup(user, "form");
        collaboratorsAvatars.setOwnAvatarVisible(false);
        Avatar ownAvatar = new Avatar();
        ownAvatar.addClassName("own-avatar");
        ownAvatar.setName(username);
        HorizontalLayout avatarLayout = new HorizontalLayout(new Component[]{collaboratorsAvatars, ownAvatar});
        avatarLayout.setWidthFull();
        avatarLayout.setSpacing(false);
        avatarLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.add(new Component[]{avatarLayout, firstName, lastName, submitButton, this.log});
        this.binder = new CollaborationBinder(Person.class, user);
        this.binder.setTopic("form", Person::new);
        this.binder.forField((HasValue)firstName).bind("firstName");
        this.binder.forField((HasValue)lastName).bind("lastName");
        this.closeConnection = CollaborationEngine.getInstance().openTopicConnection((Component)submitButton, "form", user, (SerializableFunction & Serializable)topic -> this.configureTopicConnection(topic, username, firstName, lastName));
    }

    private Registration configureTopicConnection(TopicConnection topic, String username, TextField firstName, TextField lastName) {
        Registration firstNameFocusRegistration = firstName.addFocusListener((ComponentEventListener & Serializable)event -> DemoView.logEditorFocused((TopicConnection)topic, (String)"firstName", (String)username));
        Registration lastNameFocusRegistration = lastName.addFocusListener((ComponentEventListener & Serializable)event -> DemoView.logEditorFocused((TopicConnection)topic, (String)"lastName", (String)username));
        Registration firstNameBlurRegistration = firstName.addBlurListener((ComponentEventListener & Serializable)event -> DemoView.logEditorBlurred((TopicConnection)topic, (String)"firstName", (String)username));
        Registration lastNameBlurRegistration = lastName.addBlurListener((ComponentEventListener & Serializable)event -> DemoView.logEditorBlurred((TopicConnection)topic, (String)"lastName", (String)username));
        Registration valueChangeRegistration = this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                DemoView.log((TopicConnection)topic, (String)(username + " changed " + ((TextField)e.getHasValue()).getLabel() + " to " + e.getValue()));
            }
        });
        topic.getNamedMap("activityLog").subscribe(event -> this.log.setText((String)event.getValue(String.class)));
        DemoView.log((TopicConnection)topic, (String)(username + " joined"));
        Registration & Serializable editorRegistration = (Registration & Serializable)() -> DemoView.log((TopicConnection)topic, (String)(username + " left"));
        return Registration.combine((Registration[])new Registration[]{firstNameFocusRegistration, lastNameFocusRegistration, firstNameBlurRegistration, lastNameBlurRegistration, valueChangeRegistration, editorRegistration});
    }

    private static void log(TopicConnection topic, String message) {
        DemoView.updateMaps((CollaborationMap)topic.getNamedMap("activityLog"), (String)"log", String.class, (Object)"", (T oldLog) -> message + "\n" + oldLog);
    }

    private static <T> void updateMaps(CollaborationMap map, String key, Class<T> type, T nullValue, Function<T, T> updater) {
        Object oldValue = map.get(key, type);
        T newValue = updater.apply(oldValue == null ? nullValue : oldValue);
        map.replace(key, oldValue, newValue).thenAccept(success -> {
            if (!success.booleanValue()) {
                DemoView.updateMaps((CollaborationMap)map, (String)key, (Class)type, (Object)nullValue, (Function)updater);
            }
        });
    }

    private static void logEditorFocused(TopicConnection topicConnection, String fieldName, String username) {
        String message = username + " started editing " + fieldName;
        DemoView.log((TopicConnection)topicConnection, (String)message);
    }

    private static void logEditorBlurred(TopicConnection topicConnection, String fieldName, String username) {
        String message = username + " stopped editing " + fieldName;
        DemoView.log((TopicConnection)topicConnection, (String)message);
    }
}

