/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.vaadin.HazelcastBackend;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.MembershipListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class HazelcastBackend
extends Backend {
    private final HazelcastInstance hz;
    private final IMap<String, Backend.Snapshot> snapshots;

    public HazelcastBackend(HazelcastInstance hz) {
        this.hz = Objects.requireNonNull(hz);
        this.snapshots = hz.getMap(HazelcastBackend.class.getName() + ".snapshots");
    }

    public Registration addMembershipListener(MembershipListener membershipListener) {
        UUID registrationId = this.hz.getCluster().addMembershipListener((com.hazelcast.cluster.MembershipListener)new /* Unavailable Anonymous Inner Class!! */);
        return (Registration & Serializable)() -> this.hz.getCluster().removeMembershipListener(registrationId);
    }

    public Backend.EventLog openEventLog(String topicId) {
        return new HazelcastEventLog(this.hz.getList(topicId));
    }

    public UUID getNodeId() {
        return this.hz.getCluster().getLocalMember().getUuid();
    }

    public CompletableFuture<Backend.Snapshot> loadLatestSnapshot(String name) {
        Objects.requireNonNull(name, "Name cannot be null");
        return CompletableFuture.completedFuture((Backend.Snapshot)this.snapshots.get((Object)name));
    }

    public CompletableFuture<Void> replaceSnapshot(String name, UUID expectedId, UUID newId, String payload) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(newId, "New ID cannot be null");
        Backend.Snapshot currentSnapshot = (Backend.Snapshot)this.snapshots.computeIfAbsent((Object)name, k -> new Backend.Snapshot(null, null));
        if (Objects.equals(expectedId, currentSnapshot.getId())) {
            Backend.Snapshot idAndPayload = new Backend.Snapshot(newId, payload);
            this.snapshots.put((Object)name, (Object)idAndPayload);
        }
        return CompletableFuture.completedFuture(null);
    }
}

