/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.accordion;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.accordion.AccordionPanel;
import org.jetbrains.annotations.Nullable;

@Tests(value={Accordion.class})
public class AccordionTester<T extends Accordion>
extends ComponentTester<T> {
    public AccordionTester(T component) {
        super(component);
    }

    public void openDetails(String summary) {
        this.ensureComponentIsUsable();
        AccordionPanel childPanel = this.getPanelBySummary(summary);
        if (childPanel == null) {
            throw new IllegalArgumentException("No dropdown found for '" + summary + "'");
        }
        ((Accordion)this.getComponent()).open(childPanel);
        this.roundTrip();
    }

    public boolean isOpen(String summary) {
        this.ensureVisible();
        AccordionPanel childPanel = this.getPanelBySummary(summary);
        return this.isOpen(childPanel);
    }

    public AccordionPanel getPanel(String summary) {
        this.ensureVisible();
        AccordionPanel panel = this.getPanelBySummary(summary);
        if (!this.isOpen(panel)) {
            throw new IllegalStateException("Requested panel is not open to the user");
        }
        return panel;
    }

    public boolean hasPanel(String summary) {
        return this.getPanelBySummary(summary) != null;
    }

    private boolean isOpen(AccordionPanel childPanel) {
        if (((Accordion)this.getComponent()).getOpenedPanel().isPresent()) {
            return ((AccordionPanel)((Accordion)this.getComponent()).getOpenedPanel().get()).equals(childPanel);
        }
        return false;
    }

    @Nullable
    private AccordionPanel getPanelBySummary(String summary) {
        AccordionPanel childPanel = ((Accordion)this.getComponent()).getChildren().filter(child -> child instanceof AccordionPanel).map(AccordionPanel.class::cast).filter(panel -> panel.getSummaryText().equals(summary)).findFirst().orElse(null);
        return childPanel;
    }
}

