/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.browserless.BrowserlessTestSetupException;
import com.vaadin.browserless.ComponentQuery;
import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.ComponentTesterPackages;
import com.vaadin.browserless.TestSignalEnvironment;
import com.vaadin.browserless.Tests;
import com.vaadin.browserless.ViewPackages;
import com.vaadin.browserless.internal.MockInternalSeverError;
import com.vaadin.browserless.internal.MockVaadin;
import com.vaadin.browserless.internal.Routes;
import com.vaadin.browserless.internal.ShortcutsKt;
import com.vaadin.browserless.internal.UtilsKt;
import com.vaadin.browserless.mocks.MockedUI;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.RouteParameters;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBrowserlessTest {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BaseBrowserlessTest.class.getPackageName());
    private static final ConcurrentHashMap<String, Routes> routesCache = new ConcurrentHashMap();
    protected static final Map<Class<?>, Class<? extends ComponentTester>> testers = new HashMap();
    protected static final Set<String> scanned = new HashSet<String>();
    private TestSignalEnvironment signalsTestEnvironment;

    protected static Map<Class<?>, Class<? extends ComponentTester>> scanForTesters(String ... packages) {
        try (ScanResult scan = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(packages).scan(2);){
            ClassInfoList testerList = scan.getClassesWithAnnotation(Tests.class.getName());
            HashMap testerMap = new HashMap();
            testerList.filter(classInfo -> classInfo.extendsSuperclass(ComponentTester.class)).forEach(classInfo -> {
                try {
                    Class<? extends Component>[] annotation;
                    Class<?> tester = UtilsKt.findClassOrThrow(classInfo.getName());
                    for (Class<? extends Component> component : annotation = tester.getAnnotation(Tests.class).value()) {
                        testerMap.put(component, tester);
                    }
                    String[] classes = tester.getAnnotation(Tests.class).fqn();
                    Arrays.stream(classes).map(clazz -> {
                        try {
                            return UtilsKt.findClassOrThrow(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            BaseBrowserlessTest.logTypeLoadingIssue(e, "Tester '{}' cannot be loaded because of missing component class '{}' on classpath", classInfo.getName(), clazz);
                            return null;
                        }
                    }).filter(Objects::nonNull).forEach(clazz -> testerMap.put(clazz, tester));
                }
                catch (TypeNotPresentException e) {
                    BaseBrowserlessTest.logTypeLoadingIssue(e, "Tester '{}' cannot be loaded because of missing class '{}' on classpath", classInfo.getName(), e.typeName());
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    BaseBrowserlessTest.logTypeLoadingIssue(e, "Tester '{}' cannot be loaded because of missing class on classpath: {}", classInfo.getName(), e.getMessage());
                }
            });
            Map<Class<?>, Class<? extends ComponentTester>> map = Collections.unmodifiableMap(testerMap);
            return map;
        }
    }

    private static void logTypeLoadingIssue(Throwable ex, String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message, (Object)args, (Object)ex);
        } else {
            LOGGER.warn(message, args);
        }
    }

    protected synchronized Routes discoverRoutes() {
        return BaseBrowserlessTest.discoverRoutes(this.scanPackages());
    }

    protected static synchronized Routes discoverRoutes(Set<String> packageNames) {
        packageNames = packageNames == null || packageNames.isEmpty() ? Set.of("") : packageNames;
        return packageNames.stream().map(pkg -> routesCache.computeIfAbsent((String)pkg, p -> new Routes().autoDiscoverViews((String)p))).reduce(new Routes(), Routes::merge);
    }

    protected void initVaadinEnvironment() {
        this.scanTesters();
        MockVaadin.setup(this.discoverRoutes(), MockedUI::new, this.lookupServices());
        this.initSignalsSupport();
    }

    protected void initSignalsSupport() {
        this.signalsTestEnvironment = TestSignalEnvironment.register();
    }

    protected void scanTesters() {
        List<String> packages;
        if (this.getClass().isAnnotationPresent(ComponentTesterPackages.class) && !scanned.containsAll(packages = Arrays.asList(this.getClass().getAnnotation(ComponentTesterPackages.class).value()))) {
            scanned.addAll(packages);
            testers.putAll(BaseBrowserlessTest.scanForTesters(this.getClass().getAnnotation(ComponentTesterPackages.class).value()));
        }
    }

    protected Set<String> scanPackages() {
        HashSet<String> packagesToScan = new HashSet<String>();
        if (this.getClass().isAnnotationPresent(ViewPackages.class)) {
            ViewPackages packages = this.getClass().getAnnotation(ViewPackages.class);
            Stream.of(packages.classes()).map(Class::getPackageName).collect(Collectors.toCollection(() -> packagesToScan));
            packagesToScan.addAll(Set.of(packages.packages()));
            if (packagesToScan.isEmpty()) {
                packagesToScan.add(this.getClass().getPackageName());
            }
        }
        packagesToScan.removeIf(Objects::isNull);
        return packagesToScan;
    }

    protected void cleanVaadinEnvironment() {
        if (this.signalsTestEnvironment != null) {
            this.signalsTestEnvironment.unregister();
            this.signalsTestEnvironment = null;
        }
        MockVaadin.tearDown();
    }

    protected Set<Class<?>> lookupServices() {
        return Collections.emptySet();
    }

    public <T extends Component> T navigate(Class<T> navigationTarget) {
        this.verifyAndGetUI().navigate(navigationTarget);
        return this.validateNavigationTarget(navigationTarget);
    }

    private <T extends Component> T validateNavigationTarget(Class<T> navigationTarget) {
        HasElement currentView = this.getCurrentView();
        if (!navigationTarget.isAssignableFrom(currentView.getClass())) {
            if (currentView instanceof MockInternalSeverError) {
                System.err.println(currentView.getElement().getProperty("stackTrace"));
            }
            throw new IllegalArgumentException("Navigation resulted in unexpected class " + currentView.getClass().getName() + " instead of " + navigationTarget.getName());
        }
        return (T)((Component)navigationTarget.cast(currentView));
    }

    public <C, T extends Component> T navigate(Class<T> navigationTarget, C parameter) {
        this.verifyAndGetUI().navigate(navigationTarget, parameter);
        return this.validateNavigationTarget(navigationTarget);
    }

    public <T extends Component> T navigate(Class<T> navigationTarget, Map<String, String> parameters) {
        this.verifyAndGetUI().navigate(navigationTarget, new RouteParameters(parameters));
        return this.validateNavigationTarget(navigationTarget);
    }

    public <T extends Component> T navigate(String location, Class<T> expectedTarget) {
        this.verifyAndGetUI().navigate(location);
        return this.validateNavigationTarget(expectedTarget);
    }

    public void fireShortcut(Key key, KeyModifier ... modifiers) {
        UI ui = this.verifyAndGetUI();
        if (ui.hasModalComponent()) {
            ShortcutsKt._fireShortcut(ui.getInternals().getActiveModalComponent(), key, (Key[])modifiers);
        } else {
            ShortcutsKt.fireShortcut(key, (Key[])modifiers);
        }
    }

    public HasElement getCurrentView() {
        return (HasElement)this.verifyAndGetUI().getInternals().getActiveRouterTargetsChain().get(0);
    }

    protected static <T extends ComponentTester<Y>, Y extends Component> T internalWrap(Y component) {
        return (T)BaseBrowserlessTest.initialize(BaseBrowserlessTest.getTester(component.getClass()), component);
    }

    protected static <T extends ComponentTester<Y>, Y extends Component> T internalWrap(Class<T> wrap, Y component) {
        return BaseBrowserlessTest.initialize(wrap, component);
    }

    protected static <T extends Component> ComponentQuery<T> internalQuery(Class<T> componentType) {
        return new ComponentQuery<T>(componentType);
    }

    public <T extends ComponentTester<Y>, Y extends Component> T test(Y component) {
        this.verifyAndGetUI();
        return BaseBrowserlessTest.internalWrap(component);
    }

    public <T extends ComponentTester<Y>, Y extends Component> T test(Class<T> tester, Y component) {
        this.verifyAndGetUI();
        return BaseBrowserlessTest.initialize(tester, component);
    }

    private static <Y extends Component> Class<? extends ComponentTester> getTester(Class<Y> component) {
        Class<Y> latest = component;
        do {
            if (!testers.containsKey(latest)) continue;
            return testers.get(latest);
        } while (!Component.class.equals(latest = latest.getSuperclass()));
        return ComponentTester.class;
    }

    public <T extends Component> ComponentQuery<T> $(Class<T> componentType) {
        this.verifyAndGetUI();
        return BaseBrowserlessTest.internalQuery(componentType);
    }

    public <T extends Component> ComponentQuery<T> $(Class<T> componentType, Component fromThis) {
        this.verifyAndGetUI();
        return new ComponentQuery<T>(componentType).from(fromThis);
    }

    public <T extends Component> ComponentQuery<T> $view(Class<T> componentType) {
        Component viewComponent = (Component)this.getCurrentView().getElement().getComponent().orElseThrow(() -> new AssertionError((Object)"Cannot get Component instance for current view"));
        return new ComponentQuery<T>(componentType).from(viewComponent);
    }

    private static <T extends ComponentTester<Y>, Y extends Component> T initialize(Class<T> clazz, Y component) {
        try {
            Class<?> aClass = BaseBrowserlessTest.detectComponentType(clazz);
            return (T)((ComponentTester)clazz.getConstructor(aClass).newInstance(component));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not instantiate " + clazz.getSimpleName() + " for component " + component.getClass().getSimpleName());
        }
    }

    protected static void roundTrip() {
        UI.getCurrent().getInternals().getStateTree().collectChanges(nodeChange -> {});
        UI.getCurrent().getInternals().getStateTree().runExecutionsBeforeClientResponse();
    }

    protected final boolean runPendingSignalsTasks() {
        return this.runPendingSignalsTasks(100L, TimeUnit.MILLISECONDS);
    }

    protected final boolean runPendingSignalsTasks(long maxWaitTime, TimeUnit unit) {
        if (this.signalsTestEnvironment != null) {
            return this.signalsTestEnvironment.runPendingTasks(maxWaitTime, unit);
        }
        return false;
    }

    static Class<?> detectComponentType(Class<? extends ComponentTester> testerType) {
        if (testerType == ComponentTester.class) {
            return Component.class;
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<? extends ComponentTester> clazz = testerType;
        while (!clazz.equals(ComponentTester.class)) {
            BaseBrowserlessTest.extractTypeArguments(typeMap, clazz);
            clazz = clazz.getSuperclass();
        }
        return GenericTypeReflector.erase((Type)((Type)typeMap.get(ComponentTester.class.getTypeParameters()[0])));
    }

    private static void extractTypeArguments(Map<Type, Type> typeMap, Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        TypeVariable<Class<T>>[] typeParameter = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] actualTypeArgument = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeParameter.length; ++i) {
            if (typeMap.containsKey(actualTypeArgument[i])) {
                actualTypeArgument[i] = typeMap.get(actualTypeArgument[i]);
            }
            typeMap.put(typeParameter[i], actualTypeArgument[i]);
        }
    }

    private UI verifyAndGetUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            String message = "Test Vaadin environment is not initialized correctly. This may happen when the test is extending the wrong base class for the testing engine in use. Current test class is expected to run with " + this.testingEngine() + ".";
            throw new BrowserlessTestSetupException(message);
        }
        return ui;
    }

    protected abstract String testingEngine();

    static {
        testers.putAll(BaseBrowserlessTest.scanForTesters("com.vaadin.flow.component"));
    }
}

