/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless.mocks;

import jakarta.servlet.http.HttpSession;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/vaadin/browserless/mocks/SessionAttributeEntrySetIterator;", "", "", "", "", "session", "Ljakarta/servlet/http/HttpSession;", "<init>", "(Ljakarta/servlet/http/HttpSession;)V", "getSession", "()Ljakarta/servlet/http/HttpSession;", "attrNames", "", "lastAttributeName", "hasNext", "", "next", "remove", "", "browserless-test-shared"})
final class SessionAttributeEntrySetIterator
implements Iterator<Map.Entry<String, Object>>,
KMutableIterator {
    @NotNull
    private final HttpSession session;
    @NotNull
    private final Iterator<String> attrNames;
    @Nullable
    private String lastAttributeName;

    public SessionAttributeEntrySetIterator(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Enumeration enumeration = this.session.getAttributeNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        this.attrNames = ((List)arrayList).iterator();
    }

    @NotNull
    public final HttpSession getSession() {
        return this.session;
    }

    @Override
    public boolean hasNext() {
        return this.attrNames.hasNext();
    }

    @Override
    @NotNull
    public Map.Entry<String, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.lastAttributeName = this.attrNames.next();
        Intrinsics.checkNotNull((Object)string);
        String string2 = this.lastAttributeName;
        Intrinsics.checkNotNull((Object)string2);
        return new AbstractMap.SimpleEntry<String, Object>(string, this.session.getAttribute(string2));
    }

    @Override
    public void remove() {
        if (!(this.lastAttributeName != null)) {
            throw new IllegalStateException("Check failed.");
        }
        String string = this.lastAttributeName;
        Intrinsics.checkNotNull((Object)string);
        this.session.removeAttribute(string);
        this.lastAttributeName = null;
    }
}

