/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public final class SerializationDebugUtil {
    private SerializationDebugUtil() {
    }

    public static void assertSerializable(Object root, StringBuilder report) {
        try {
            SerializationDebugUtil.serialize(root);
        }
        catch (NotSerializableException e) {
            if (report == null) {
                report = new StringBuilder();
            }
            report.append(SerializationDebugUtil.buildReport(root, e));
            throw new AssertionError("Serialization failed: " + e.getMessage() + "\n" + report.toString(), e);
        }
        catch (IOException ioe) {
            throw new AssertionError("Unexpected IO failure during serialization: " + ioe.getMessage(), ioe);
        }
    }

    public static void assertSerializable(Object root) {
        SerializationDebugUtil.assertSerializable(root, null);
    }

    private static void serialize(Object o) throws IOException {
        if (o == null) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(o);
        }
    }

    private static String buildReport(Object root, NotSerializableException original) {
        StringBuilder sb = new StringBuilder();
        sb.append("---- Serialization Debug Report ----\n");
        sb.append("Root type: ").append(root.getClass().getName()).append('\n');
        sb.append("Original exception: ").append(original).append('\n');
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        ArrayList<String> offenders = new ArrayList<String>();
        SerializationDebugUtil.inspectObject(root, "root", visited, offenders);
        if (offenders.isEmpty()) {
            sb.append("No direct non-Serializable fields found.\n");
        } else {
            sb.append("Non-serializable field paths:\n");
            offenders.forEach(p -> sb.append("  - ").append((String)p).append('\n'));
        }
        sb.append("------------------------------------");
        return sb.toString();
    }

    private static void inspectObject(Object obj, String path, Set<Object> visited, List<String> offenders) {
        if (obj == null || visited.contains(obj)) {
            return;
        }
        visited.add(obj);
        Class<?> cls = obj.getClass();
        if (SerializationDebugUtil.isKnownSerializableLeaf(cls)) {
            return;
        }
        if (!(obj instanceof Serializable)) {
            offenders.add(path + " (" + cls.getName() + ")");
            return;
        }
        for (Field f : SerializationDebugUtil.getAllFields(cls)) {
            Object value;
            if (SerializationDebugUtil.shouldSkip(f)) continue;
            try {
                f.setAccessible(true);
            }
            catch (Exception ignored) {
                continue;
            }
            try {
                value = f.get(obj);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (value == null) continue;
            String childPath = path + "." + f.getName();
            if (!(value instanceof Serializable)) {
                offenders.add(childPath + " (" + value.getClass().getName() + ")");
                continue;
            }
            try {
                SerializationDebugUtil.serialize(value);
            }
            catch (NotSerializableException nse) {
                SerializationDebugUtil.inspectObject(value, childPath, visited, offenders);
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean shouldSkip(Field f) {
        int mod = f.getModifiers();
        return Modifier.isStatic(mod) || Modifier.isTransient(mod);
    }

    private static List<Field> getAllFields(Class<?> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (cls != null && cls != Object.class) {
            fields.addAll(Arrays.asList(cls.getDeclaredFields()));
            cls = cls.getSuperclass();
        }
        return fields;
    }

    private static boolean isKnownSerializableLeaf(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || Number.class.isAssignableFrom(cls) || cls == Boolean.class || cls == Character.class || cls.isEnum() || cls.getName().startsWith("java.time.");
    }
}

