/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.listbox.ListBox;
import java.util.List;
import java.util.stream.Collectors;

@Tests(fqn={"com.vaadin.flow.component.listbox.ListBox"})
public class ListBoxTester<T extends ListBox<V>, V>
extends ComponentTester<T> {
    public ListBoxTester(T component) {
        super(component);
    }

    public V getSelected() {
        return (V)((ListBox)this.getComponent()).getValue();
    }

    public void selectItem(String selection) {
        this.ensureComponentIsUsable();
        if (selection == null) {
            this.setValueAsUser(null);
            return;
        }
        List filtered = this.getSuggestionItems().stream().filter(item -> selection.equals(this.getItemLabel(item))).collect(Collectors.toList());
        if (filtered.size() != 1) {
            throw new IllegalArgumentException("No item found for '" + selection + "'");
        }
        this.setValueAsUser(filtered.get(0));
    }

    public List<String> getSuggestions() {
        List<V> suggestionItems = this.getSuggestionItems();
        return suggestionItems.stream().map(this::getItemLabel).collect(Collectors.toList());
    }

    private String getItemLabel(V item) {
        ItemLabelGenerator itemLabelGenerator = ((ListBox)this.getComponent()).getItemLabelGenerator();
        if (itemLabelGenerator != null) {
            return itemLabelGenerator.apply(item);
        }
        return item.toString();
    }

    public List<V> getSuggestionItems() {
        return ((ListBox)this.getComponent()).getGenericDataView().getItems().collect(Collectors.toList());
    }
}

