/*
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.browserless.mocks;

import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

import com.vaadin.browserless.internal.UIFactory;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.SpringVaadinServletService;

/**
 * A mocking service that performs three very important tasks:
 * <ul>
 * <li>Overrides {@link #isAtmosphereAvailable} to tell Vaadin that we don't
 * have Atmosphere (otherwise Vaadin will crash)</li>
 * <li>Provides some dummy value as a root ID via {@link #getMainDivId}
 * (otherwise the mocked servlet env will crash).</li>
 * <li>Provides a {@link MockSpringVaadinSession} instead of
 * {@link com.vaadin.flow.spring.SpringVaadinSession}.</li>
 * </ul>
 * The class is intentionally opened, to be extensible in user's library.
 *
 * @author mavi
 */
public class MockSpringServletService extends SpringVaadinServletService {
    @NotNull
    private final UIFactory uiFactory;

    @Deprecated(forRemoval = true)
    public MockSpringServletService(@NotNull MockSpringServlet servlet,
            @NotNull DeploymentConfiguration deploymentConfiguration,
            @NotNull ApplicationContext ctx, @NotNull Function0<UI> uiFactory) {
        super(servlet, deploymentConfiguration, ctx);
        this.uiFactory = uiFactory::invoke;
    }

    public MockSpringServletService(@NotNull MockSpringServlet servlet,
            @NotNull DeploymentConfiguration deploymentConfiguration,
            @NotNull ApplicationContext ctx, @NotNull UIFactory uiFactory) {
        super(servlet, deploymentConfiguration, ctx);
        this.uiFactory = uiFactory;
    }

    @Override
    protected boolean isAtmosphereAvailable() {
        return false;
    }

    @Override
    public String getMainDivId(VaadinSession session, VaadinRequest request) {
        return "ROOT-1";
    }

    @Override
    protected VaadinSession createVaadinSession(VaadinRequest request) {
        return new MockSpringVaadinSession(this, uiFactory);
    }

    @Override
    public Instantiator getInstantiator() {
        return MockInstantiator.create(super.getInstantiator());
    }
}
