/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalTime;

@Tests(value={TimePicker.class})
public class TimePickerTester<T extends TimePicker>
extends ComponentTester<T> {
    public TimePickerTester(T component) {
        super(component);
    }

    public void setValue(LocalTime time) {
        this.ensureComponentIsUsable();
        try {
            if (this.isInvalid(time)) {
                throw new IllegalArgumentException("Given time is not a valid value");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setValueAsUser(time);
    }

    private boolean isInvalid(LocalTime date) throws InvocationTargetException, IllegalAccessException {
        try {
            Method isInvalid = this.getMethod("isInvalid", LocalDate.class);
            return (Boolean)isInvalid.invoke(this.getComponent(), date);
        }
        catch (RuntimeException ex) {
            if (!(ex.getCause() instanceof NoSuchMethodException)) {
                throw ex;
            }
            return ((TimePicker)this.getComponent()).getDefaultValidator().apply((Object)date, null).isError();
        }
    }
}

