/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.HtmlContainerTester;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

@Tests(value={Anchor.class})
public class AnchorTester
extends HtmlContainerTester<Anchor> {
    public AnchorTester(Anchor component) {
        super(component);
    }

    public String getHref() {
        this.ensureComponentIsUsable();
        return ((Anchor)this.getComponent()).getHref();
    }

    public String getPath() {
        return URI.create(this.getHref()).getPath();
    }

    public QueryParameters getQueryParameters() {
        return QueryParameters.fromString((String)URI.create(this.getHref()).getQuery());
    }

    public HasElement navigate() {
        this.ensureComponentIsUsable();
        Field href = this.getField(Anchor.class, "href");
        try {
            if (href.get(this.getComponent()) instanceof String) {
                if (RouteConfiguration.forSessionScope().getRoute(this.getPath()).isPresent()) {
                    UI.getCurrent().navigate(this.getPath(), this.getQueryParameters());
                    return (HasElement)UI.getCurrent().getInternals().getActiveRouterTargetsChain().get(0);
                }
                throw new IllegalStateException("Anchor is not for an application route");
            }
            throw new IllegalStateException("Anchor target seems to be a resource");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void click() {
        this.navigate();
    }

    public void download(final OutputStream outputStream) {
        this.ensureComponentIsUsable();
        Anchor anchor = (Anchor)this.getComponent();
        VaadinSession session = VaadinSession.getCurrent();
        StreamResourceRegistry registry = session.getResourceRegistry();
        Optional maybeResource = Optional.empty();
        try {
            maybeResource = registry.getResource(new URI(anchor.getHref()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        AbstractStreamResource resource = maybeResource.filter(res -> {
            StreamResourceRegistry.ElementStreamResource el;
            return res instanceof StreamResource || res instanceof StreamResourceRegistry.ElementStreamResource && (el = (StreamResourceRegistry.ElementStreamResource)res).getElementRequestHandler() instanceof DownloadHandler;
        }).orElseThrow(() -> new IllegalStateException("Anchor target does not seem to be a resource"));
        if (resource instanceof StreamResource) {
            StreamResource cast = (StreamResource)resource;
            try {
                cast.getWriter().accept(outputStream, session);
            }
            catch (IOException e) {
                throw new RuntimeException("Download failed", e);
            }
        }
        StreamResourceRegistry.ElementStreamResource elementResource = (StreamResourceRegistry.ElementStreamResource)resource;
        DownloadHandler handler = (DownloadHandler)elementResource.getElementRequestHandler();
        DownloadEvent event = new DownloadEvent(this, VaadinRequest.getCurrent(), VaadinResponse.getCurrent(), session, elementResource.getOwner()){
            private boolean outputStreamCalled;
            private boolean writerCalled;

            public OutputStream getOutputStream() {
                if (this.writerCalled) {
                    throw new IllegalStateException("Cannot execute getOutputStream() after getWriter() has been called");
                }
                this.outputStreamCalled = true;
                return outputStream;
            }

            public PrintWriter getWriter() {
                if (this.outputStreamCalled) {
                    throw new IllegalStateException("Cannot execute getWriter() after getOutputStream() has been called");
                }
                this.writerCalled = true;
                return new PrintWriter(outputStream);
            }
        };
        try {
            handler.handleDownloadRequest(event);
        }
        catch (IOException e) {
            throw new RuntimeException("Download failed", e);
        }
    }
}

