/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.radiobutton.RadioButton;
import java.util.function.Consumer;

@Tests(fqn={"com.vaadin.flow.component.radiobutton.RadioButton"})
public class RadioButtonTester<T extends RadioButton<V>, V>
extends ComponentTester<T> {
    public RadioButtonTester(T component) {
        super(component);
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.isDisabled();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (this.isDisabled()) {
            collector.accept("disabled");
        }
    }

    @Override
    public void click() {
        this.ensureComponentIsUsable();
        RadioButton radioButton = (RadioButton)this.getComponent();
        ComponentUtil.fireEvent((Component)radioButton, (ComponentEvent)new ClickEvent((Component)radioButton, true, 0, 0, 0, 0, 0, 0, false, false, false, false));
        radioButton.setChecked(true);
    }

    protected boolean isDisabled() {
        return ((RadioButton)this.getComponent()).getElement().getProperty("disabled", false);
    }
}

