/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.messages.MessageListItem;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

@Tests(value={MessageList.class})
public class MessageListTester<T extends MessageList>
extends ComponentTester<T> {
    public MessageListTester(T component) {
        super(component);
    }

    public int size() {
        this.ensureComponentIsUsable();
        return ((MessageList)this.getComponent()).getItems().size();
    }

    public MessageListItem getMessage(int index) {
        this.ensureComponentIsUsable();
        return (MessageListItem)((MessageList)this.getComponent()).getItems().get(index);
    }

    public List<MessageListItem> getMessages() {
        this.ensureComponentIsUsable();
        return ((MessageList)this.getComponent()).getItems();
    }

    public List<MessageListItem> getMessages(Instant start, Instant end) {
        this.ensureComponentIsUsable();
        return ((MessageList)this.getComponent()).getItems().stream().filter(message -> message.getTime() != null).filter(message -> message.getTime().isAfter(start) && message.getTime().isBefore(end)).collect(Collectors.toList());
    }

    public List<MessageListItem> getMessagesAfter(Instant start) {
        this.ensureComponentIsUsable();
        return ((MessageList)this.getComponent()).getItems().stream().filter(message -> message.getTime() != null).filter(message -> message.getTime().isAfter(start)).collect(Collectors.toList());
    }

    public List<MessageListItem> getMessagesBefore(Instant end) {
        this.ensureComponentIsUsable();
        return ((MessageList)this.getComponent()).getItems().stream().filter(message -> message.getTime() != null).filter(message -> message.getTime().isBefore(end)).collect(Collectors.toList());
    }

    public List<MessageListItem> getMessages(String userName) {
        this.ensureComponentIsUsable();
        List items = ((MessageList)this.getComponent()).getItems();
        if (userName == null) {
            return items.stream().filter(message -> message.getUserName() == null).collect(Collectors.toList());
        }
        return items.stream().filter(message -> userName.equals(message.getUserName())).collect(Collectors.toList());
    }
}

