/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless;

import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.signals.SignalEnvironment;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class TestSignalEnvironment
extends SignalEnvironment {
    private final LinkedBlockingQueue<Runnable> tasks = new LinkedBlockingQueue();
    private Runnable cleanup;

    protected TestSignalEnvironment() {
    }

    public static TestSignalEnvironment register() {
        TestSignalEnvironment environment = new TestSignalEnvironment();
        environment.cleanup = SignalEnvironment.register((SignalEnvironment)environment);
        return environment;
    }

    public void unregister() {
        if (this.cleanup != null) {
            this.cleanup.run();
            this.cleanup = null;
        }
    }

    protected boolean isActive() {
        return true;
    }

    protected Executor getResultNotifier() {
        return this.createTaskEnqueueExecutor();
    }

    protected Executor getEffectDispatcher() {
        return this.createTaskEnqueueExecutor();
    }

    private Executor createTaskEnqueueExecutor() {
        return this.tasks::offer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runPendingTasks(long maxWaitTime, TimeUnit unit) {
        long waitMillis = unit.toMillis(maxWaitTime);
        VaadinSession session = VaadinSession.getCurrent();
        boolean hadLock = false;
        if (session != null && session.hasLock()) {
            hadLock = true;
            session.unlock();
        }
        try {
            Runnable task;
            try {
                task = waitMillis > 0L ? this.tasks.poll(waitMillis, TimeUnit.MILLISECONDS) : this.tasks.poll();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError((Object)"Thread interrupted while waiting for pending Signals tasks");
            }
            if (task == null) {
                LoggerFactory.getLogger(TestSignalEnvironment.class).debug("No pending Signals tasks found after waiting for {} {}", (Object)maxWaitTime, (Object)unit);
                boolean bl = false;
                return bl;
            }
            while (task != null) {
                task.run();
                task = this.tasks.poll();
            }
        }
        finally {
            if (hadLock) {
                session.lock();
            }
        }
        return true;
    }
}

