/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.HtmlComponent;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.jsoup.Jsoup;

public final class ElementConditions {
    private ElementConditions() {
        throw new AssertionError((Object)"Must not be instantiated");
    }

    public static <T extends Component> Predicate<T> containsText(String text) {
        return ElementConditions.containsText(text, false);
    }

    public static <T extends Component> Predicate<T> containsText(String text, boolean ignoreCase) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        return new TextContainsPredicate(text, ignoreCase);
    }

    public static <T extends Component> Predicate<T> hasAttribute(String attribute) {
        return component -> component.getElement().hasAttribute(attribute);
    }

    public static <T extends Component> Predicate<T> hasAttribute(String attribute, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return component -> Objects.equals(component.getElement().getAttribute(attribute), value);
    }

    public static <T extends Component> Predicate<T> hasNotAttribute(String attribute) {
        return component -> !component.getElement().hasAttribute(attribute);
    }

    public static <T extends Component> Predicate<T> hasNotAttribute(String attribute, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return component -> !Objects.equals(component.getElement().getAttribute(attribute), value);
    }

    private static class TextContainsPredicate<T extends Component>
    implements Predicate<T> {
        private final String text;
        private final boolean ignoreCase;

        public TextContainsPredicate(String text, boolean ignoreCase) {
            this.text = text;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean test(T component) {
            String componentText;
            if (component instanceof HasText) {
                componentText = ((HasText)component).getText();
            } else if (component instanceof HtmlComponent) {
                componentText = component.getElement().getTextRecursively();
            } else if (component instanceof Html) {
                componentText = ((Html)component).getInnerHtml();
                if (componentText != null) {
                    componentText = Jsoup.parse((String)componentText).text();
                }
            } else {
                componentText = component.getElement().isTextNode() ? component.getElement().getText() : component.getElement().getTextRecursively();
            }
            if (componentText == null) {
                return false;
            }
            if (this.ignoreCase) {
                return componentText.toLowerCase(Locale.ROOT).contains(this.text.toLowerCase(Locale.ROOT));
            }
            return componentText.contains(this.text);
        }
    }
}

