/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.browserless;

import com.vaadin.browserless.MetaKeys;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;

public interface Clickable<T extends Component> {
    public T getComponent();

    public void ensureComponentIsUsable();

    default public void click() {
        this.click(0, new MetaKeys());
    }

    default public void click(MetaKeys metaKeys) {
        this.click(0, metaKeys);
    }

    default public void middleClick() {
        this.click(1, new MetaKeys());
    }

    default public void middleClick(MetaKeys metaKeys) {
        this.click(1, metaKeys);
    }

    default public void rightClick() {
        this.click(2, new MetaKeys());
    }

    default public void rightClick(MetaKeys metaKeys) {
        this.click(2, metaKeys);
    }

    default public void click(int button, MetaKeys metaKeys) {
        this.ensureComponentIsUsable();
        T component = this.getComponent();
        ComponentUtil.fireEvent(component, (ComponentEvent)new ClickEvent(component, true, 0, 0, 0, 0, 0, button, metaKeys.isCtrl(), metaKeys.isShift(), metaKeys.isAlt(), metaKeys.isMeta()));
    }
}

