/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification;

import com.vaadin.browserless.ComponentTester;
import com.vaadin.browserless.Tests;
import com.vaadin.flow.component.notification.Notification;
import java.util.function.Consumer;

@Tests(value={Notification.class})
public class NotificationTester<T extends Notification>
extends ComponentTester<T> {
    public NotificationTester(T component) {
        super(component);
    }

    public String getText() {
        this.ensureComponentIsUsable();
        return ((Notification)this.getComponent()).getElement().getProperty("text");
    }

    public void autoClose() {
        this.ensureComponentIsUsable();
        if (((Notification)this.getComponent()).getDuration() <= 0) {
            throw new IllegalStateException("Auto-close is not enabled");
        }
        ((Notification)this.getComponent()).close();
    }

    @Override
    public boolean isUsable() {
        Notification component = (Notification)this.getComponent();
        return component.isVisible() && component.isAttached() && component.isOpened();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        Notification component = (Notification)this.getComponent();
        if (!component.isAttached()) {
            collector.accept("not attached");
        }
        if (!component.isVisible()) {
            collector.accept("not visible");
        }
        if (component.isOpened()) {
            collector.accept("not opened");
        }
    }
}

