import { css as d, LitElement as u, html as f } from "lit";
import { property as l, customElement as g } from "lit/decorators.js";
var o = /* @__PURE__ */ ((e) => (e.INFORMATION = "information", e.WARNING = "warning", e.ERROR = "error", e))(o || {}), v = Object.defineProperty, m = Object.getOwnPropertyDescriptor, c = (e, i, p, a) => {
  for (var t = a > 1 ? void 0 : a ? m(i, p) : i, s = e.length - 1, r; s >= 0; s--)
    (r = e[s]) && (t = (a ? r(i, p, t) : r(t)) || t);
  return a && t && v(i, p, t), t;
};
let n = class extends u {
  constructor() {
    super(...arguments), this.appSecRoute = "/vaadin-appsec-kit", this.message = "No data available yet.";
  }
  render() {
    return f`
            <div class="container">
                <span>${this.message}</span>
                <button id="open-appsec-kit" class="open-appsec-kit-button"
                        @click="${this.openAppSecKit}">Open AppSec Kit
                </button>
            </div>
        `;
  }
  openAppSecKit() {
    window.open(this.appSecRoute, "_blank");
  }
  handleMessage(e) {
    if (e.command === "appsec-kit-init") {
      this.appSecRoute = "/" + e.data.appSecRoute;
      const i = {
        type: o.INFORMATION,
        message: "AppSec Kit is running",
        details: "AppSec Kit is configured and scanning app dependencies for known vulnerabilities."
      };
      return window.Vaadin.copilot.eventbus.emit("copilot-ide-notification", i), this.message = "AppSec Kit is configured and scanning app dependencies for known vulnerabilities.", !0;
    } else if (e.command === "appsec-kit-scan") {
      if (e.data.vulnerabilityCount > 0) {
        const i = {
          type: o.ERROR,
          message: "Potential vulnerabilities found"
        };
        window.Vaadin.copilot.eventbus.emit("copilot-ide-notification", i), this.message = e.data.vulnerabilityCount + " potential vulnerabilities found.";
      } else {
        const i = {
          type: o.INFORMATION,
          message: "No vulnerabilities found"
        };
        window.Vaadin.copilot.eventbus.emit("copilot-ide-notification", i), this.message = "No vulnerabilities found.";
      }
      return !0;
    } else
      return !1;
  }
};
n.styles = d`
        .container {
            align-items: center;
            display: flex;
            padding: 0.75rem;
            justify-content: space-between;
        }

        .open-appsec-kit-button {
            align-items: center;
            background: var(--gray-100);
            border: 1px solid transparent;
            border-radius: var(--radius-1);
            color: var(--color-high-contrast);
            display: flex;
            font: var(--font-xsmall-medium);
            flex-shrink: 0;
            gap: var(--space-75);
            height: 1.75rem;
            justify-content: center;
            padding: 0 var(--space-100);

            &:hover {
                background: var(--gray-200);
            }
        }
    `;
c([
  l()
], n.prototype, "appSecRoute", 2);
c([
  l()
], n.prototype, "message", 2);
n = c([
  g("appsec-kit-plugin")
], n);
const b = {
  header: "AppSec Kit",
  expanded: !1,
  panelOrder: 65,
  panel: "right",
  floating: !1,
  tag: "appsec-kit-plugin"
}, h = {
  init(e) {
    e.addPanel(b);
  }
};
window.Vaadin.copilot.plugins.push(h);
export {
  n as AppSecKitPlugin
};
