/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.views;

import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.model.AppSecData;
import com.vaadin.appsec.backend.model.analysis.AffectedVersion;
import com.vaadin.appsec.backend.model.analysis.AssessmentStatus;
import com.vaadin.appsec.backend.model.dto.SeverityLevel;
import com.vaadin.appsec.backend.model.dto.Vulnerability;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.server.Version;
import java.io.Serializable;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class VulnerabilityDetailsView
extends VerticalLayout {
    private final DateFormat dateFormatter = DateFormat.getDateInstance(2, UI.getCurrent().getLocale());
    private final DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2, UI.getCurrent().getLocale());
    private final Vulnerability vulnerabilityDTO;
    private final Runnable closeCallback;
    private Button saveButton;
    private ComboBox<AppSecData.VulnerabilityStatus> developerStatus;
    private TextArea developerAnalysis;
    private Span lastUpdated;

    public VulnerabilityDetailsView(Vulnerability vulnerabilityDTO, Runnable closeCallback) {
        this.vulnerabilityDTO = vulnerabilityDTO;
        this.closeCallback = closeCallback;
        this.setSizeFull();
        this.setMargin(false);
        this.addClassName("vulnerability-details-view");
        this.buildHeaderBar();
        this.buildContent();
    }

    private void buildHeaderBar() {
        HorizontalLayout header = new HorizontalLayout();
        header.addClassName("vulnerability-header");
        header.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        header.setWidth(100.0f, Unit.PERCENTAGE);
        Button backButton = new Button((Component)new Icon(VaadinIcon.CHEVRON_LEFT));
        backButton.addClassName("navigate-back-button");
        backButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        backButton.addClassName("border-0");
        backButton.addClassName("bg-transparent");
        backButton.setAriaLabel("Navigate back");
        backButton.setTooltipText("Navigate back");
        backButton.addClickListener((ComponentEventListener & Serializable)e -> this.closeCallback.run());
        header.add(new Component[]{backButton});
        Span vulnerabilityTitle = new Span(this.vulnerabilityDTO.getIdentifier());
        vulnerabilityTitle.addClassName("vulnerability-title");
        header.addAndExpand(new Component[]{vulnerabilityTitle});
        this.add(new Component[]{header});
    }

    private void buildContent() {
        Component leftContent = this.buildLeftContent();
        Component rightContent = this.buildRightContent();
        HorizontalLayout content = new HorizontalLayout(new Component[]{leftContent, rightContent});
        content.expand(new Component[]{leftContent});
        content.setSizeFull();
        content.addClassName("vulnerability-details-content-panel");
        this.addAndExpand(new Component[]{content});
    }

    private Component buildLeftContent() {
        VerticalLayout left = new VerticalLayout();
        left.addClassName("vulnerability-details-content-left");
        left.setMargin(true);
        left.add(new Component[]{this.buildProperties()});
        left.add(new Component[]{this.buildVaadinAnalysis()});
        left.add(new Component[]{this.buildVulnerabilityDesc()});
        left.add(new Component[]{this.buildReferences()});
        HorizontalLayout leftPanel = new HorizontalLayout(new Component[]{left});
        leftPanel.setSizeFull();
        leftPanel.addClassName("border-0");
        return leftPanel;
    }

    private Component buildProperties() {
        HorizontalLayout properties = new HorizontalLayout();
        properties.setWidth(100.0f, Unit.PERCENTAGE);
        properties.add(new Component[]{this.buildLabel("Ecosystem", this.vulnerabilityDTO.getDependency().getEcosystem().toString())});
        properties.add(new Component[]{this.buildLabel("Dependency", this.vulnerabilityDTO.getDependency().toString())});
        properties.add(new Component[]{this.buildLabel("Version", this.vulnerabilityDTO.getDependency().getVersion())});
        properties.add(new Component[]{this.buildLabel("Patched in version", this.vulnerabilityDTO.getPatchedVersion())});
        properties.add(new Component[]{this.buildLabel("Risk rating", String.valueOf(this.vulnerabilityDTO.getRiskScore()))});
        properties.add(new Component[]{this.buildLabel("Status", "---")});
        properties.add(new Component[]{this.buildLabel("Time of detection", this.dateFormatter.format(this.vulnerabilityDTO.getDatePublished()))});
        SeverityLevel severityLevel = this.vulnerabilityDTO.getSeverityLevel();
        Component severity = this.buildLabel("Severity", String.valueOf(severityLevel) + (SeverityLevel.NONE == severityLevel ? "" : " severity"));
        severity.addClassName("severity-" + this.vulnerabilityDTO.getSeverityLevel().name());
        properties.add(new Component[]{severity});
        return properties;
    }

    private Component buildLabel(String caption, String value) {
        Span propertyValue = new Span(value);
        propertyValue.setId(caption);
        NativeLabel propertyLabel = new NativeLabel(caption);
        propertyLabel.setFor((Component)propertyValue);
        propertyLabel.addClassName("vulnerability-property-label");
        VerticalLayout layout = new VerticalLayout(new Component[]{propertyLabel, propertyValue});
        layout.addClassName("vulnerability-details-property-holder");
        layout.setSizeUndefined();
        return layout;
    }

    private Component buildVaadinAnalysis() {
        VerticalLayout vaadinAnalysisPanel = new VerticalLayout();
        vaadinAnalysisPanel.addClassName("vaadin-analysis-panel");
        vaadinAnalysisPanel.addClassName("m-s");
        Span vaadinAnalysisTitle = new Span("Vaadin analysis");
        vaadinAnalysisTitle.addClassName("vaadin-analysis-title");
        vaadinAnalysisTitle.setWidth(100.0f, Unit.PERCENTAGE);
        vaadinAnalysisPanel.add(new Component[]{vaadinAnalysisTitle});
        String flowVersion = Version.getFullVersion();
        AppSecService service = AppSecService.getInstance();
        List flowVersions = service.getSupportedFlowVersions();
        boolean isSupportedVaadinVersion = flowVersions.contains(flowVersion);
        Span vaadinAnalysisStatus = new Span();
        Span vaadinAnalysisDesc = new Span();
        if (!isSupportedVaadinVersion) {
            vaadinAnalysisStatus.setText("Not Provided");
            vaadinAnalysisStatus.addClassName("vaadin-analysis-not-supported");
            vaadinAnalysisDesc.setText("This app is running with Vaadin Flow " + flowVersion + " which is not currently getting security updates. Please  upgrade to one of the latest maintained versions: " + String.join((CharSequence)", ", flowVersions));
        } else {
            AffectedVersion affectedVersion = this.vulnerabilityDTO.getAffectedVersion();
            if (affectedVersion != null) {
                AssessmentStatus status = affectedVersion.getStatus();
                vaadinAnalysisStatus.setText(status.toString());
                this.setStatusStyle(vaadinAnalysisStatus, status);
                String comment = affectedVersion.getComment();
                vaadinAnalysisDesc.setText(comment);
            } else {
                vaadinAnalysisStatus.setText("Not Available");
                vaadinAnalysisDesc.setText("This vulnerability has not yet been assessed by the Vaadin Security Team. Please check later for updates.");
                vaadinAnalysisStatus.addClassName("vaadin-analysis-not-available");
            }
        }
        vaadinAnalysisDesc.addClassName("vaadin-analysis-desc");
        vaadinAnalysisDesc.setWidth(100.0f, Unit.PERCENTAGE);
        vaadinAnalysisPanel.add(new Component[]{vaadinAnalysisStatus});
        vaadinAnalysisPanel.add(new Component[]{vaadinAnalysisDesc});
        return vaadinAnalysisPanel;
    }

    private void setStatusStyle(Span vaadinAnalysisStatus, AssessmentStatus status) {
        switch (status) {
            case TRUE_POSITIVE: {
                vaadinAnalysisStatus.addClassName("vaadin-analysis-true-positive");
                break;
            }
            case FALSE_POSITIVE: {
                vaadinAnalysisStatus.addClassName("vaadin-analysis-false-positive");
                break;
            }
            case UNDER_REVIEW: {
                vaadinAnalysisStatus.addClassName("vaadin-analysis-under-review");
                break;
            }
            default: {
                vaadinAnalysisStatus.addClassName("vaadin-analysis-not-supported");
            }
        }
    }

    private Component buildVulnerabilityDesc() {
        VerticalLayout vulnerabilityDescPanel = new VerticalLayout();
        Span vulnerabilityDescTitle = new Span("Vulnerability description");
        vulnerabilityDescTitle.addClassName("vulnerability-desc-title");
        vulnerabilityDescTitle.setWidth(100.0f, Unit.PERCENTAGE);
        vulnerabilityDescPanel.add(new Component[]{vulnerabilityDescTitle});
        String cleanedDetails = Jsoup.clean((String)this.vulnerabilityDTO.getDetails(), (Safelist)Safelist.relaxed());
        Html vulnerabilityDesc = new Html("<div>\n" + cleanedDetails + "\n</div>");
        vulnerabilityDesc.addClassName("vulnerability-desc");
        vulnerabilityDescPanel.add(new Component[]{vulnerabilityDesc});
        return vulnerabilityDescPanel;
    }

    private Component buildReferences() {
        VerticalLayout referencesPanel = new VerticalLayout();
        Span referencesTitle = new Span("References");
        referencesTitle.addClassName("references-title");
        referencesTitle.setWidth(100.0f, Unit.PERCENTAGE);
        referencesPanel.add(new Component[]{referencesTitle});
        List<Html> links = this.vulnerabilityDTO.getReferenceUrls().stream().map(url -> new Html("<a href=\"" + url + "\" target=\"_blank\">" + url + "</a>")).toList();
        links.forEach(xva$0 -> referencesPanel.add(new Component[]{xva$0}));
        return referencesPanel;
    }

    private Component buildRightContent() {
        VerticalLayout right = new VerticalLayout();
        right.addClassName("vulnerability-details-content-right");
        right.addClassName("m-s");
        right.setMargin(true);
        right.setHeight(100.0f, Unit.PERCENTAGE);
        right.setWidth(400.0f, Unit.PIXELS);
        right.add(new Component[]{this.buildDeveloperAnalysisTitle()});
        right.add(new Component[]{this.buildDeveloperAnalysisDesc()});
        right.add(new Component[]{this.buildDeveloperStatus()});
        right.addAndExpand(new Component[]{this.buildDeveloperAnalysis()});
        right.add(new Component[]{this.buildLastUpdated()});
        right.add(new Component[]{this.buildSaveButton()});
        right.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.saveButton});
        return right;
    }

    private Component buildDeveloperAnalysisTitle() {
        Span developerAnalysisTitle = new Span("Developer analysis");
        developerAnalysisTitle.addClassName("developer-analysis-title");
        developerAnalysisTitle.setWidth(100.0f, Unit.PERCENTAGE);
        return developerAnalysisTitle;
    }

    private Component buildDeveloperAnalysisDesc() {
        Span developerAnalysisDesc = new Span("You can declare a status for this vulnerability if you have done some analysis on this vulnerability or want to perform an analysis on this vulnerability.");
        developerAnalysisDesc.setWidth(100.0f, Unit.PERCENTAGE);
        developerAnalysisDesc.addClassName("developer-analysis-desc");
        return developerAnalysisDesc;
    }

    private Component buildDeveloperStatus() {
        this.developerStatus = new ComboBox();
        this.developerStatus.setItems((Object[])new AppSecData.VulnerabilityStatus[]{AppSecData.VulnerabilityStatus.NOT_SET, AppSecData.VulnerabilityStatus.NOT_AFFECTED, AppSecData.VulnerabilityStatus.FALSE_POSITIVE, AppSecData.VulnerabilityStatus.IN_TRIAGE, AppSecData.VulnerabilityStatus.EXPLOITABLE});
        this.developerStatus.setPlaceholder("Select status");
        this.developerStatus.setWidth(100.0f, Unit.PERCENTAGE);
        this.developerStatus.setLabel("Vulnerability status");
        this.developerStatus.setValue((Object)this.vulnerabilityDTO.getDeveloperStatus());
        this.developerStatus.addValueChangeListener(this::developerAnalysisChanged);
        return this.developerStatus;
    }

    private Component buildDeveloperAnalysis() {
        this.developerAnalysis = new TextArea("Description (optional)");
        this.developerAnalysis.setPlaceholder("Add a description that describes the state of this vulnerability");
        this.developerAnalysis.setWidth(100.0f, Unit.PERCENTAGE);
        if (this.vulnerabilityDTO.getDeveloperAnalysis() != null) {
            this.developerAnalysis.setValue(this.vulnerabilityDTO.getDeveloperAnalysis());
        }
        this.developerAnalysis.addValueChangeListener(this::developerAnalysisChanged);
        return this.developerAnalysis;
    }

    private void developerAnalysisChanged(HasValue.ValueChangeEvent<?> event) {
        this.saveButton.setEnabled(!Objects.equals(this.vulnerabilityDTO.getDeveloperStatus(), this.developerStatus.getValue()) || !Objects.equals(this.vulnerabilityDTO.getDeveloperAnalysis(), this.developerAnalysis.getValue()));
    }

    private Component buildLastUpdated() {
        String timestamp = this.vulnerabilityDTO.getDeveloperUpdated() == null ? "-" : this.dateTimeFormatter.format(Date.from(this.vulnerabilityDTO.getDeveloperUpdated()));
        this.lastUpdated = new Span("Last updated: " + timestamp);
        this.lastUpdated.setWidth(310.0f, Unit.PIXELS);
        return this.lastUpdated;
    }

    private Component buildSaveButton() {
        this.saveButton = new Button("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.saveButton.setAriaLabel("Save developer analysis");
        this.saveButton.setTooltipText("Save developer analysis");
        this.saveButton.addClickListener(this::save);
        return this.saveButton;
    }

    private void save(ClickEvent<Button> clickEvent) {
        if (this.developerStatus.getValue() == null) {
            this.developerStatus.setValue((Object)AppSecData.VulnerabilityStatus.NOT_SET);
        }
        String id = this.vulnerabilityDTO.getIdentifier();
        AppSecData data = AppSecService.getInstance().getData();
        AppSecData.VulnerabilityAssessment vulnerability = (AppSecData.VulnerabilityAssessment)data.getVulnerabilities().get(id);
        if (vulnerability == null) {
            vulnerability = new AppSecData.VulnerabilityAssessment();
        }
        vulnerability.setId(id);
        vulnerability.setStatus((AppSecData.VulnerabilityStatus)this.developerStatus.getValue());
        vulnerability.setDeveloperAnalysis(this.developerAnalysis.getValue());
        Instant now = Instant.now();
        vulnerability.setUpdated(now);
        data.getVulnerabilities().put(id, vulnerability);
        AppSecService.getInstance().setData(data);
        this.lastUpdated.setText("Last updated: " + this.dateTimeFormatter.format(Date.from(now)));
        this.saveButton.setEnabled(false);
    }
}

