/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.views;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.streams.DownloadHandler;
import java.io.Serializable;

public abstract class AbstractAppSecView
extends VerticalLayout {
    static final String DEPENDENCY = "Dependency";
    static final String DEPENDENCY_GROUP = "Dependency group";
    static final String DEPENDENCY_NAME = "Dependency name";
    static final String ECOSYSTEM = "Ecosystem";
    static final String SEVERITY = "Severity";
    static final String CVSS_SCORE = "CVSS score";
    static final String VAADIN_ANALYSIS = "Vaadin analysis";
    static final String DEVELOPER_ANALYSIS = "Developer analysis";
    static final String IS_DEVELOPMENT = "Is development?";
    static final String NUMBER_OF_VULNERABILITIES = "# of vulnerabilities";
    static final String HIGHEST_SEVERITY = "Highest severity";
    static final String HIGHEST_CVSS_SCORE = "Highest CVSS score";
    static final String VERSION = "Version";
    static final String SEARCH = "Search";
    static final String SHOW_DETAILS = "Show details";
    static final String VULNERABILITY_NAME_OR_IDENTIFIER = "Vulnerability name or identifier";
    private final VerticalLayout mainContent;
    protected Anchor exportLink;

    AbstractAppSecView() {
        this.setSizeFull();
        this.mainContent = new VerticalLayout();
        this.mainContent.setSizeFull();
        this.mainContent.setMargin(false);
        this.showMainContent();
    }

    abstract void refresh();

    Component buildFilterBar(Component ... filters) {
        HorizontalLayout filterBar = new HorizontalLayout();
        filterBar.setWidth(100.0f, Unit.PERCENTAGE);
        filterBar.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        filterBar.add(filters);
        filterBar.expand(filters);
        filterBar.add(new Component[]{this.buildClearButton()});
        filterBar.add(new Component[]{this.buildExportButton()});
        return filterBar;
    }

    Button buildClearButton() {
        Button clear = new Button("Clear");
        clear.addClickListener((ComponentEventListener & Serializable)e -> this.clearFilters());
        return clear;
    }

    Anchor buildExportButton() {
        this.exportLink = new Anchor();
        this.exportLink.getElement().setAttribute("download", true);
        this.exportLink.add(new Component[]{new Button("Export", (Component)VaadinIcon.DOWNLOAD.create())});
        return this.exportLink;
    }

    void updateExportData(DownloadHandler downloadHandler) {
        this.exportLink.setHref(downloadHandler);
    }

    void clearFilters() {
    }

    void applyFilters() {
    }

    void showDetails(Component detailsContent) {
        this.removeAll();
        this.addAndExpand(new Component[]{detailsContent});
    }

    VerticalLayout getMainContent() {
        return this.mainContent;
    }

    void showMainContent() {
        this.removeAll();
        this.addAndExpand(new Component[]{this.mainContent});
    }
}

