/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.service;

import com.vaadin.appsec.backend.AppSecScanEventListener;
import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.Registration;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.flow.component.dependency.JsModule;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsModule(value="./appsec-kit/appsec-kit-plugin.js", developmentOnly=true)
public class AppSecDevToolsPlugin
implements DevToolsMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSecDevToolsPlugin.class);
    private final Map<DevToolsInterface, Registration> scanEventRegistrations = new ConcurrentHashMap<DevToolsInterface, Registration>();

    public void handleConnect(DevToolsInterface devToolsInterface) {
        AppSecService appSecService = AppSecService.getInstance();
        String appSecRoute = appSecService.getConfiguration().getAppSecRoute();
        this.sendInitData(appSecRoute, devToolsInterface);
        if (!this.scanEventRegistrations.containsKey(devToolsInterface)) {
            Registration registration = appSecService.addScanEventListener((AppSecScanEventListener & Serializable)event -> {
                int vulnerabilityCount = event.getNewVulnerabilities().size();
                this.sendScanResult(vulnerabilityCount, devToolsInterface);
                LOGGER.debug("Scan event received. Vulnerabilities sent to the client: " + vulnerabilityCount);
            });
            this.scanEventRegistrations.put(devToolsInterface, registration);
            LOGGER.debug("Scan event listener added");
        }
        this.sendScanResult(appSecService.getNewVulnerabilities().size(), devToolsInterface);
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        return false;
    }

    public void handleDisconnect(DevToolsInterface devToolsInterface) {
        Registration registration = this.scanEventRegistrations.remove(devToolsInterface);
        if (registration != null) {
            registration.remove();
            LOGGER.debug("Scan event listener removed");
        }
    }

    private void sendInitData(String appSecRoute, DevToolsInterface devToolsInterface) {
        JsonObject data = Json.createObject();
        data.put("appSecRoute", appSecRoute);
        devToolsInterface.send("appsec-kit-init", data);
    }

    private void sendScanResult(int vulnerabilityCount, DevToolsInterface devToolsInterface) {
        JsonObject data = Json.createObject();
        data.put("vulnerabilityCount", (double)vulnerabilityCount);
        devToolsInterface.send("appsec-kit-scan", data);
    }
}

